// ===================================================
// hairSynth - a simple vector graphics hair generator
// Copyright (C) 2007 JM Bara <http://www.codemuse.net>
// See licence terms in file "READ ME"
// ===================================================
// Uses Processing <http://processing.org>
// Uses SimplePostscript v.0092 <http:www.unlekker.net>
// ===================================================

/*****************************************************
 * Class Oscill1 holds the three instances of the Oscill1
 * class, needed to hold the parameters used to shape
 * the master hair strand.
 *
 * The method calcRadius is at the heart of of the algorithm
 * used to convert the six shape parameters into the shape
 * of the strand.
 */

package hairSynth;

final class Oscill3 { // first test Oscill1

	private Oscill1[] osc1 = { new Oscill1(), new Oscill1(), new Oscill1() };

	Oscill3() {
		/* do nothing */
	}

	// ===== GETTERS AND SETTERS ===============================================
	double getPeriod(final int ixOsc) {

		return this.osc1[ixOsc].getPeriod();
	}

	double getMult0(final int ixOsc) {

		return this.osc1[ixOsc].getMult0();
	}

	double getMult1(final int ixOsc) {

		return this.osc1[ixOsc].getMult1();
	}

	void setOscParams(final int ixOsc, final double period_, final double mult0_, final double mult1_) {

		this.osc1[ixOsc].setOscParams(period_, mult0_, mult1_);
	}

	// =========================================================================
	void copyOscParamsFrom(final Oscill3 sourceOsc_) {

		for (int ixOsc = K.ixOscBLU0; ixOsc <= K.ixOscRED2; ixOsc++) {

			double period_ = sourceOsc_.getPeriod(ixOsc);
			double mult0_ = sourceOsc_.getMult0(ixOsc);
			double mult1_ = sourceOsc_.getMult1(ixOsc);

			this.setOscParams(ixOsc, period_, mult0_, mult1_);
		}
	}

	void copyAndJiggleOscParams(final Oscill3 sourceOsc_, final double jiggleFactor) {

		for (int ixOsc = K.ixOscBLU0; ixOsc <= K.ixOscRED2; ixOsc++) {

			double period_ = sourceOsc_.getPeriod(ixOsc) + jiggleFactor * (Math.random() - 0.5) / 20.0;
			double mult0_ = sourceOsc_.getMult0(ixOsc) + jiggleFactor * (Math.random() - 0.5) / 10.0;
			double mult1_ = sourceOsc_.getMult1(ixOsc) + jiggleFactor * (Math.random() - 0.5) / 5.0;

			this.setOscParams(ixOsc, period_, mult0_, mult1_);
		}
	}

	double calcRadius(final double dist) {

		double distNormalized = dist / K.totalStrandLEN;

		double invRadSum = 0.0f;

		for (int ix = K.ixOscBLU0; ix <= K.ixOscRED2; ix++) {

			invRadSum += this.osc1[ix].calcInvRad(dist, distNormalized);
		}
		if (invRadSum == 0.0f) {
			return K.BIGNUM;
		}
		return (1.0f / invRadSum);
	}

	double calcDistBefFirstReversion(final double dist) {

		double distBefFirstReversion = K.BIGNUM;

		for (int ix = K.ixOscBLU0; ix <= K.ixOscRED2; ix++) {

			distBefFirstReversion = Math.min(distBefFirstReversion, this.osc1[ix].calcDistBefReversion(dist));
		}
		return (distBefFirstReversion);
	}
}
