// ===================================================
// hairSynth - a simple vector graphics hair generator
// Copyright (C) 2007 JM Bara <http://www.codemuse.net>
// See licence terms in file "READ ME"
// ===================================================
// Uses Processing <http://processing.org>
// Uses SimplePostscript v.0092 <http:www.unlekker.net>
// ===================================================

/*****************************************************
 * Class Oscill1 holds the variables used to set the
 * shape of the master hair strand.  A strand uses
 * three instances of this class.
 */


package hairSynth;

final class Oscill1 {

	private double period;
	private double mult0;
	private double mult1;


	Oscill1() {
		this.period = K.PI1;
		this.mult0 = 0.0f;
		this.mult1 = 0.0f;
	}


	double getPeriod() {
		return this.period;
	}

	double getMult0() {
		return this.mult0;
	}

	double getMult1() {
		return this.mult1;
	}

	void setOscParams(final double period_, final double mult0_, final double mult1_) {

		this.period = period_;
		this.mult0 = mult0_;
		this.mult1 = mult1_;
	}

	double calcInvRad(final double dist, final double distNormalized) { // distNormalized 0..1

		double phase = 0.0f;
		// ----- calc phase
		double modDist = dist % this.period;
		if (modDist <= (this.period / 2.0f)) {
			phase = 1.0f;
		} else {
			phase = -1.0f;
		}

		// ----- calc radius for multiple 1
		if (this.period <= 0.0f) { // would cause overflow in calculation of inverse of radius
			System.out.println("ERROR in Oscill1 ... period must be greater than 0.0");
			return (0.0f);
		}
		double rad1 = this.period / K.PI2 ;

		// ----- calc multiplier as f(distance)
		double mult = this.mult0 + distNormalized * (this.mult1 - this.mult0);

		return (phase * mult / rad1);
	}

	double calcDistBefReversion(final double dist) {
		double halfPeriod = this.period / 2.0f;
		return ( halfPeriod - (dist % halfPeriod));
	}
}
