// ===================================================
// hairSynth - a simple vector graphics hair generator
// Copyright (C) 2007 JM Bara <http://www.codemuse.net>
// See licence terms in file "READ ME"
// ===================================================
// Uses Processing <http://processing.org>
// Uses SimplePostscript v.0092 <http:www.unlekker.net>
// ===================================================



package hairSynth;

import processing.core.PApplet;

public final class Main extends PApplet {

	// /////////////////////////////////////////////////////////////////////////
	// Set isApplic to true if intend to run as application
	static final boolean isAPPLIC = false;
	// Set ixSize manually if applet (isAPPLIC = false); otherwise set in Setup
	static int ixSIZE = 1; // Set by setup if Applic. 0=small, 1=default, 2=large
	// size 0 is 840x640; size 1 is 800x1000; sise 2 is working but unused
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

	private boolean isMousePressed = false;
	private boolean isDraggingDisk = false;
	private boolean isDraggingZoom = false;
	private boolean isMousePonDash = false;

	private int mPressedX;
	private int mPressedY;
	private int mReleasdX;
	private int mReleasdY;

	private int actionWaitingToBeProcessed = K.no_____ACTION;

	private boolean isSetShapeStepRedrawAll = true;
	private boolean isSetShapeStepIsEasing = true;
	private boolean isWriteFacetsNeeded = false;

	private Dash dash;

	private BufferSingle bufferSingle;
	private BufferBunch bufferBunch;
	private BufferView[] bufferView = new BufferView[K.ixViewTOTAL];

	private DiskCanvas diskCanvas;
	private ZoomCanvas zoomCanvas;

	private FilePS ps;

	// use "Run as application" ... Also set isAPPLIC to true
	public static void main(final String[] args) {
		PApplet.main(new String[] { "--present", "hairSynth.Main" });
	}

	public void setup() {
		if (isAPPLIC) { // for size of Applet, change ixSize manually above
			ixSIZE = 0;
			if (((K.CANVAS_SCALE[1] + K.DASH_WIDTH[1]) <= this.screen.width) //
					&& (K.CANVAS_SCALE[1] <= this.screen.height)) {
				ixSIZE = 1;
				// if (((K.CANVAS_SCALE[2] + K.DASH_WIDTH[2]) <= this.screen.width) //
				// && (K.CANVAS_SCALE[2] <= this.screen.height)) {
				// ixSIZE = 2;
				//				}
			}
		}

		K.init(); // initialize dimensions before creation of classes
		// ----- create objects
		this.ps = new FilePS(this);

		this.dash = new Dash(this);

		this.bufferSingle = new BufferSingle(this);
		this.bufferBunch = new BufferBunch(this, this.bufferSingle.getStrand());
		for (int ixView = 0; ixView < K.ixViewTOTAL; ixView++) {
			this.bufferView[ixView] = new BufferView(this, this.ps, this.bufferBunch, ixView);
		}

		this.diskCanvas = new DiskCanvas(this);
		this.zoomCanvas = new ZoomCanvas(this);

		for (int ixDisk = 0; ixDisk < K.totDISKS4; ixDisk++) {
			float paramX = K.shapePresetX(K.totalPRESETS - 1, ixDisk);
			float paramY = K.shapePresetY(K.totalPRESETS - 1, ixDisk);
			this.bufferSingle.setParamsFromDiskXYPositions(ixDisk, paramX, paramY);
		}

		// ----- set applet properties
		size((int) K.DASH_WIDTH[ixSIZE] + (int) K.canvasScale, (int) K.canvasScale);
		background(255);
		smooth();
		frameRate(50);

		this.dash.repaintSetShapeStateDash();
	}

	public void draw() { // Processing Loop

		if (this.isMousePonDash) {
			if ((K.saveFileState == K.inactiveSAVEFILE) || (K.saveFileState == K.doneSAVEFILE)) {
				this.actionWaitingToBeProcessed = this.dash.recordActiveButtonIfHover(this.mPressedX, this.mPressedY);
				if (this.actionWaitingToBeProcessed != K.no_____ACTION) {
					actOnResultOfButtonPressed(this.actionWaitingToBeProcessed);
				}
				// debug: System.out.println("acted on " + K.actionsSTR[this.actionWaitingToBeProcessed]);
				this.actionWaitingToBeProcessed = K.no_____ACTION;
			} // do not take in new actions while saving
			this.isMousePonDash = false;
		} else {
			this.dash.testForHoverOverButtons(this.mouseX, this.mouseY);
		}

		// /////////////////////////////////////////////////////////////////////
		// ----- actual work gets done here
		boolean isWorkedThisCycle = false;
		switch (K.ixStepButOn) {
		case K.shapeSTEP:
			isWorkedThisCycle = drawSingleStrandAndDisks(isWorkedThisCycle);
			break;
		case K.colorSTEP:
			isWorkedThisCycle = this.bufferBunch.populateAndRender(isWorkedThisCycle);
			isWorkedThisCycle = drawZoomReticleIfNeeded(isWorkedThisCycle);
			break;
		case K.viewsSTEP:
			isWorkedThisCycle = this.bufferView[K.ixZoomSwatchButOn].populateAndRender(isWorkedThisCycle);
			if ((!isAPPLIC) && isWorkedThisCycle) {
				this.dash.repaintViewStateDash();
			}
			if (this.isWriteFacetsNeeded) {
				this.dash.writeFacets();
				this.isWriteFacetsNeeded = false;
			}
			this.dash.writeSaveFileMessageIfNecessary();
			break;
		default:
			/* do nothing */
			break;
		}
		this.dash.drawFPS(this.frameRate, isWorkedThisCycle);
	}

	// /////////////////////////////////////////////////////////////////////////
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// /////////////////////////////////////////////////////////////////////////

	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

	private void actOnResultOfButtonPressed(final int action_) {

		switch (action_) { // action reset after test

		case K.no_____ACTION:
			/* do nothing */
			break;
		case K.newStepACTION:
			initializeNewStepAsAresultOfButtonPressed();
			if (K.saveFileState == K.doneSAVEFILE) {
				K.saveFileState = K.inactiveSAVEFILE;
			}
			break;
		case K.presetsACTION:
			if (K.ixPresetButOn > -1) {
				for (int ixDisk = 0; ixDisk < K.totDISKS4; ixDisk++) {
					float paramX = K.shapePresetX(K.ixPresetButOn, ixDisk);
					float paramY = K.shapePresetY(K.ixPresetButOn, ixDisk);
					this.diskCanvas.setDiskXY(ixDisk, paramX, paramY);
					this.bufferSingle.setParamsFromDiskXYPositions(ixDisk, paramX, paramY);
				}
				this.isSetShapeStepRedrawAll = true;
				this.zoomCanvas.setIsZoomCtrSetByUser(false); // params changed ... zoom reset
				K.ixPresetButOn = -1; // done ... reset ... so that button does not highlight
			}
			this.isSetShapeStepRedrawAll = true;
			break;
		case K.colors_ACTION:
		case K.bckgrndACTION:
			/* do nothing as this will be caught by scanning change in colors */
			break;
		case K.reCentrACTION:
			this.bufferBunch.reCenterAndTriggerReInitDraw();
			for (int ixBuffer = 0; ixBuffer < K.ixViewTOTAL; ixBuffer++) {
				this.bufferView[ixBuffer].triggerInitDraw();
			}
			K.isReCenterOn = false; // done ... reset
			this.isSetShapeStepRedrawAll = true;
			break;
		case K.zooSwtcACTION:
			this.bufferView[K.ixZoomSwatchButOn].triggerRefreshScreen();
			this.isWriteFacetsNeeded = true;
			if (K.saveFileState == K.doneSAVEFILE) {
				K.saveFileState = K.inactiveSAVEFILE;
			}
			break;
		case K.dpi300_ACTION:
			/* no need to initDraw as this will be caught by scanning change in colors */
			this.isWriteFacetsNeeded = true;
			if (K.saveFileState == K.doneSAVEFILE) {
				K.saveFileState = K.inactiveSAVEFILE;
			}
			break;
		case K.savFileACTION:
			this.bufferView[K.ixZoomSwatchButOn].triggerInitDraw();
			break;
		default:
			/* do nothing */
			break;
		}
	}

	private void initializeNewStepAsAresultOfButtonPressed() {

		switch (K.ixStepButOn) {

		case K.shapeSTEP:
			this.isSetShapeStepRedrawAll = true;
			// this.diskCanvas.printParams(); // used to debug
			break;
		case K.colorSTEP:
			this.bufferBunch.triggerRefreshScreen();
			this.zoomCanvas.setGraticuleColorToCurrentScheme();
			this.zoomCanvas.triggerIsRedrawNeeded();
			break;
		case K.viewsSTEP:
			this.bufferView[K.ixZoomSwatchButOn].triggerRefreshScreen();
			this.isWriteFacetsNeeded = true;
			break;
		default:
			/* do nothing */
			break;
		}
	}

	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

	// @Override
	public void mousePressed() {

		if (!this.isMousePressed) {

			this.mPressedX = this.mouseX;
			this.mPressedY = this.mouseY;

			if ((this.mouseX > K.canvas_x0) && (this.mouseX < (K.canvas_x0 + K.canvasScale))) {
				// mouse pressed on on Canvas

				if (K.ixStepButOn == K.shapeSTEP) {
					this.isDraggingDisk = this.diskCanvas.recordActiveDiskPositionOnPressIfActive(this.mouseX,
							this.mouseY);
				} else if (K.ixStepButOn == K.colorSTEP) {
					this.isDraggingZoom = this.zoomCanvas.recordZoomCenterPositionOnPressIfValidDrag(this.mouseX,
							this.mouseY);
				}
			} else { // mouse pressed on Dash
				this.isMousePonDash = true;
			}
			this.isMousePressed = true;
		}
	}

	// @Override
	public void mouseReleased() {

		if (this.isMousePressed) {
			this.mReleasdX = this.mouseX;
			this.mReleasdY = this.mouseY;
			this.isDraggingDisk = false;
			this.isDraggingZoom = false;
			this.isMousePressed = false;
		}
	}

	boolean wasMouseDragged() {
		return ((this.mPressedX != this.mReleasdX) || (this.mPressedY != this.mReleasdY));
	}

	// @Override
	public void keyReleased() {
		/* do nothing */
		// if (this.key == ' ') {
		// /* for future expansion */
		// }
	}

	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

	private boolean drawSingleStrandAndDisks(final boolean isWorkedThisCycle) { // branches designed to avoid drawing
		// when
		// no changes in params

		boolean isWorkedThisMethod = false;
		boolean isChangedDiskColor = false;

		if (this.isMousePressed) {
			if (this.isDraggingDisk && this.wasMouseDragged()) { // test if parameters changed
				int oscN = this.diskCanvas.moveActiveDiskPositionOnDrag(this.mouseX, this.mouseY);
				if (oscN > -1) {
					float activeX = this.diskCanvas.getActiveX();
					float activeY = this.diskCanvas.getActiveY();
					this.bufferSingle.setParamsFromDiskXYPositions(oscN, activeX, activeY);
					this.isSetShapeStepRedrawAll = true;
					this.zoomCanvas.setIsZoomCtrSetByUser(false); // params changed ... zoom reset
				}
			}
		} else { // only test hover on mouse released
			isChangedDiskColor = this.diskCanvas.testHoverOverDisks(this.mouseX, this.mouseY);
		}

		if (this.isSetShapeStepRedrawAll || this.isSetShapeStepIsEasing) {

			this.isSetShapeStepIsEasing = this.bufferSingle.drawSingleStrand();
			this.bufferSingle.copyToScreen();
			isWorkedThisMethod = true;
		}

		if (isChangedDiskColor || this.isSetShapeStepRedrawAll) {
			this.diskCanvas.draw();
			this.isSetShapeStepRedrawAll = this.isSetShapeStepIsEasing;
			isWorkedThisMethod = true;
		}
		return (isWorkedThisCycle || isWorkedThisMethod);
	}

	// /////////////////////////////////////////////////////////////////////////
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// /////////////////////////////////////////////////////////////////////////

	private boolean drawZoomReticleIfNeeded(final boolean isWorkedThisCycle) {

		if (this.isMousePressed) {
			if (this.isDraggingZoom && this.wasMouseDragged()) { // test if parameters changed

				boolean isMoved = this.zoomCanvas.moveZoomCenterPositionOnDrag(this.mouseX, this.mouseY);
				if (isMoved) {
					this.bufferBunch.triggerRefreshScreen(); // to erase reticule
				}
			}
		}
		boolean isWorkedThisMethod = this.zoomCanvas.drawIfNeeded(this.bufferBunch, this.mouseX, this.mouseY);

		return (isWorkedThisCycle || isWorkedThisMethod);
	}
}