// ===================================================
// hairSynth - a simple vector graphics hair generator
// Copyright (C) 2007 JM Bara <http://www.codemuse.net>
// See licence terms in file "READ ME"
// ===================================================
// Uses Processing <http://processing.org>
// Uses SimplePostscript v.0092 <http:www.unlekker.net>
// ===================================================

/*****************************************************
 * class FilePS extends the SimplePostscript class
 * to time stamp the saved PS files.
 */

package hairSynth;

import java.util.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;

import processing.core.PApplet;

public final class FilePS extends SimplePostscript {

	private static GregorianCalendar now = new GregorianCalendar();

	FilePS(final PApplet _parent) {
		super(_parent);
		/* do nothing else */
	}

	void OpenIfNecessary() { // Only called if isAPPLIC is true

		if (K.saveFileState == K.readyToSAVEFILE) {

			this.open(createFileName(), 0, 0, K.DOC_SCALE, K.DOC_SCALE);
			this.isOpen = true;
			if (KColor.ixBckgButOn == KColor.blackBCKGRND) {
				this.setrgb(0, 0, 0);
				this.psRect(0, 0, K.DOC_SCALE, K.DOC_SCALE);
			}
			K.saveFileState = K.performingSAVEFILE;
		}
	}

	void closeIfNecessary() {

		if (K.saveFileState == K.performingSAVEFILE) {
			this.close();
			this.isOpen = false;
			K.saveFileState = K.doneSAVEFILE;
		}
	}

	private void psRect(final float x1, final float y1, final float x2, final float y2) {
		this.moveto(x1, y1);
		this.lineto(x2, y1);
		this.lineto(x2, y2);
		this.lineto(x1, y2);
		this.lineto(x1, y1);
		this.fillclosepath();
	}

	// /////////////////////////////////////////////////////////////////////////
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// /////////////////////////////////////////////////////////////////////////

	private static String createFileName() {

		String outFileName = "hairSynth_" + K.zoomFileStr[K.ixZoomSwatchButOn] + "_";

		Date tempTime = new Date();
		now.setTime(tempTime);
		return (outFileName + calendarToShortString(now) + ".ps");
	}

	private static String calendarToShortString(final Calendar calendar_) {
		StringBuffer tempSBuff1 = new StringBuffer("");
		// -------------------------------------------------
		int month = calendar_.get(Calendar.MONTH) + 1;
		if (month < 10) {
			tempSBuff1.append("0").append(String.valueOf(month));
		} else {
			tempSBuff1.append(String.valueOf(month));
		}
		// -------------------------------------------------
		int date = calendar_.get(Calendar.DATE);
		if (date < 10) {
			tempSBuff1.append("0").append(String.valueOf(date));
		} else {
			tempSBuff1.append(String.valueOf(date));
		}
		// -------------------------------------------------
		int year = calendar_.get(Calendar.YEAR);
		year = year % 100; // reduces to 2 decimals
		if (year < 10) {
			tempSBuff1.append("0").append(String.valueOf(year)).append("at");
		} else {
			tempSBuff1.append(String.valueOf(year)).append("at");
		}
		// -------------------------------------------------
		int hour = calendar_.get(Calendar.HOUR_OF_DAY);
		if (hour < 10) {
			tempSBuff1.append("0").append(String.valueOf(hour));
		} else {
			tempSBuff1.append(String.valueOf(hour));
		}
		// -------------------------------------------------
		int minute = calendar_.get(Calendar.MINUTE);
		if (minute < 10) {
			tempSBuff1.append("0").append(String.valueOf(minute));
		} else {
			tempSBuff1.append(String.valueOf(minute));
		}
		// -------------------------------------------------
		return (tempSBuff1.toString());
	}

}
