// ===================================================
// hairSynth - a simple vector graphics hair generator
// Copyright (C) 2007 JM Bara <http://www.codemuse.net>
// See licence terms in file "READ ME"
// ===================================================
// Uses Processing <http://processing.org>
// Uses SimplePostscript v.0092 <http:www.unlekker.net>
// ===================================================

/*****************************************************
 * class Disk holds the coordinates of the disks
 * used to imput changes in shape parameters of the
 * master hair strand.
 * It also includes the methods that draw the disks
 * on screen.
 */

package hairSynth;

import processing.core.PApplet;

final class Disk {

	private int id;
	private float x; // relative to canvas! not to applet.
	private float y; // relative to canvas! not to applet.
	private boolean isActive;

	private PApplet papplet;

	Disk(final PApplet papplet_, final int id_, final float x_, final float y_) {
		this.papplet = papplet_;
		this.id = id_;
		this.x = x_;
		this.y = y_;
		this.isActive = false;
	}

	float getX() {
		return this.x;
	}

	float getY() {
		return this.y;
	}

	void setX(final float x_) {
		this.x = Math.max(K.diskRADIUS, Math.min(K.canvasScale - K.diskRADIUS, x_));
	}

	void setY(final float y_) {
		this.y = Math.max(K.diskRADIUS, Math.min(K.canvasScale - K.diskRADIUS, y_));
	}

	void setIsActive(final boolean bool) {
		this.isActive = bool;
	}

	float distToCenter(final float mouseXrelToCanvas, final float mouseYrelToCanvas) {
		float result = K.outOfCANVAS; // negative if not hovering over disk

		float dx = mouseXrelToCanvas - this.x;
		float dy = mouseYrelToCanvas - this.y;

		if ((Math.abs(dx) < K.diskRADIUS) && (Math.abs(dy) < K.diskRADIUS)) {

			double dist = Math.sqrt(dx * dx + dy * dy);
			if (dist <= K.diskRADIUS) {
				result = (float) dist;
			}
		}
		return result;
	}

	void draw() {
		switch (this.id) {
		case K.ixOscBLU0:
			if (this.isActive) {
				this.papplet.fill(160, 192, 255);
			} else {
				this.papplet.fill(64, 128, 255);
			}
			break;
		case K.ixOscMAG1:
			if (this.isActive) {
				this.papplet.fill(255, 128, 255);
			} else {
				this.papplet.fill(255, 0, 255);
			}
			break;
		case K.ixOscRED2:
			if (this.isActive) {
				this.papplet.fill(255, 128, 128);
			} else {
				this.papplet.fill(255, 0, 0);
			}
			break;
		case K.ixDirGRN3:
			if (this.isActive) {
				this.papplet.fill(123, 214, 105);
			} else {
				this.papplet.fill(70, 137, 102);
			}
			break;
		default:
			/* do nothing */
			break;
		}
		this.papplet.ellipse(this.x + K.canvas_x0, this.y, K.diskRADIUS * 2.0f, K.diskRADIUS * 2.0f);
	}
}
