/*
 * $Id: DebugUtil.java 1759 2005-01-16 01:03:10Z oliverscheck $
 * (c) Copyright 2000 wingS development team.
 *
 * This file is part of wingS (http://j-wings.org).
 *
 * wingS is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * Please see COPYING for the complete licence.
 */

package hairSynth;

import java.io.StringWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public final class DebugUtil {

	private static final int INTERNAL_CODE_LINE_CALL_LEVEL = 3;
	private static final StringWriter STACK_TRACE_STRING_WRITER = new StringWriter();
	private static final PrintWriter STACK_TRACE_PRINT_WRITER = new PrintWriter(STACK_TRACE_STRING_WRITER);
	private static final Throwable STACK_TRACE_EXCEPTION = new Throwable();

	/**
	 * No way to instantiate
	 */
	private DebugUtil() {
		/* do nothing */
	}

	private static synchronized String getStackTraceString() {
		return getStackTraceString(STACK_TRACE_EXCEPTION.fillInStackTrace());
	}

	public static synchronized String getStackTraceString(final Throwable e) {
		STACK_TRACE_STRING_WRITER.getBuffer().setLength(0);
		e.printStackTrace(STACK_TRACE_PRINT_WRITER);
		return STACK_TRACE_STRING_WRITER.toString();
	}

	public static String getCodeLineStack(final int callLevel) {
		StringTokenizer t = new StringTokenizer(getStackTraceString(), System.getProperty("line.separator"));

		for (int i = 0; i < callLevel + INTERNAL_CODE_LINE_CALL_LEVEL && t.hasMoreTokens(); i++) {
			t.nextToken();
		}

		if (t.hasMoreTokens()) {
			return t.nextToken().trim();
		}
		return "";
	}

	public static String getCodeLineStack() {
		return getCodeLineStack(1);
	}

	public static String getCodeLine() {
		return getCodeLine(1);
	}

	public static String getCodeLine(final int callLevel) {
		String erg = getCodeLineStack(callLevel + 1);
		int pindex = erg.lastIndexOf("(");
		if (pindex >= 0) {
			erg = erg.substring(pindex + 1, erg.length() - 1);
			int cindex = erg.indexOf(":");
			if (cindex >= 0) {
				return erg.substring(cindex + 1);
			}
		}
		return "?";
	}

	public static String getDebugMessage(final Class c, final String mesg) {
		return "[" + c.getName() + ":" + getCodeLine(2) + "] " + mesg;
	}

	/**
	 * This method should be used in a Class local static method like
	 * <CODE>
	 *      private static final void debug(String mesg)
	 *      DebugUtil.printDebugMessage(this.class, mesg)); }
	 * </CODE>
	 */
	public static void printDebugMessage(final Class c, final String mesg) {
		System.out.println("[" + c.getName() + ":" + getCodeLine(2) + "] " + mesg);
	}

// JRE 5 and over ....
//    try {
//        throw new Exception("nothing");
//    } catch (Exception e) {
//        StackTraceElement[] elements = e.getStackTrace();
//        String stackTrace ="";
//        int i=0;
//        for (StackTraceElement element: elements) {
//            if (i>0) {
//                stackTrace = stackTrace + "\n";
//            }
//            stackTrace = stackTrace + element.toString();
//            i++;
//        }
//        log.debug(message + "\n" + stackTrace);
//    }
}

