// ===================================================
// hairSynth - a simple vector graphics hair generator
// Copyright (C) 2007 JM Bara <http://www.codemuse.net>
// See licence terms in file "READ ME"
// ===================================================
// Uses Processing <http://processing.org>
// Uses SimplePostscript v.0092 <http:www.unlekker.net>
// ===================================================

/*****************************************************
 * Class Dash includes the methods that test if the
 * mouse is hovering over any buttons, that interpret
 * mouse clicks on the dashboard, and that draw the
 * buttons and messages.
 */

package hairSynth;

// import java.text.DecimalFormat;

import processing.core.PApplet;
import processing.core.PFont;

final class Dash {

	// No public vars
	private int ixStepButHover = -1;
	private int ixPresButHover = -1;
	private int ixColrButHover = -1;
	private int ixBckgButHover = -1;
	private int ixZoSwButHover = -1; // Covers both Zoom and Swatch buttons

	private boolean isReCenterHover = false;
	private boolean isReCenterHoverAsOfLastDrawn = false;
	private boolean isReCenterOnAsOfLastDrawn = false;

	private boolean isSaveFileHover = false;
	private boolean isSaveFileHoverAsOfLastDrawn = false;
	private int saveFileStateAsOfLastDrawn = K.inactiveSAVEFILE;

	private boolean isDPI300Hover = false;
	private boolean isDPI300HoverAsOfLastDrawn = false;
	private boolean isDPI300onAsOfLastDrawn = false;

	private boolean isFPShover = false;

	// ----- Step Button coordinates
	private static float dashWidth;
	private static float stepButAreaHeight;

	private static float sepWide;
	private static float sepThin;
	private static float sepBoth;
	private static float sepWid2;
	private static float BUTxLft;
	private static float BUTxRgt;
	private static float BUTxMid;
	private static float BUTwidth;
	private static float BUTheight;

	private static float[] adjButTxt = { 10.0f, 0.0f, 16.0f };

	private static final int presetButtonROW = 12;

	private static final int reCenterButtonROW = -1;
	private static final int colorButtonROW = 1;
	private static final int bckgrndButtonROW = 7;

	private static final int zoomButtonROW = 2;
	private static final int dpi300ButtonROW = 8; // toggle
	private static final int saveFileButtonROW = 10;

	// private static DecimalFormat myFloat1 = new DecimalFormat("###,###,##0.0");
	private PFont font;

	private PApplet papplet;

	// /////////////////////////////////////////////////////////////////////////
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// /////////////////////////////////////////////////////////////////////////

	Dash(final PApplet papplet_) {
		this.papplet = papplet_;

		if (Main.ixSIZE == 0) {
			this.font = this.papplet.loadFont("Verdana-12.vlw");
		} else {
			this.font = this.papplet.loadFont("Verdana-14.vlw");
		}
		this.papplet.textFont(this.font);

		dashWidth = K.DASH_WIDTH[Main.ixSIZE];
		stepButAreaHeight = K.STEP_BUT_AREA_HEIGHT[Main.ixSIZE];

		sepWide = (K.canvasScale - stepButAreaHeight) / 23.0f;
		sepThin = sepWide / 2.0f;
		sepBoth = sepWide + sepThin;
		sepWid2 = 2.0f * sepWide;

		BUTxLft = K.dash_x0 + sepWide;
		BUTxRgt = K.dash_x0 + dashWidth - sepWide;
		BUTxMid = (BUTxLft + BUTxRgt) / 2;
		BUTwidth = dashWidth - sepWid2;
		BUTheight = (stepButAreaHeight - sepWide) / K.totalSTEPS;
	}

	// /////////////////////////////////////////////////////////////////////////
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// /////////////////////////////////////////////////////////////////////////

	void clearSupeerfluousHovers() {

		switch (K.ixStepButOn) {

		case K.shapeSTEP:
			// this.ixStepButHover = -1; commented out because possible in all states
			// this.ixPresButHover = -1;
			this.isReCenterHover = false;
			this.ixColrButHover = -1;
			this.ixBckgButHover = -1;
			this.ixZoSwButHover = -1;
			this.isDPI300Hover = false;
			this.isSaveFileHover = false;
			break;
		case K.colorSTEP:
			// this.ixStepButHover = -1; commented out because possible in all states
			this.ixPresButHover = -1;
			// this.isReCenterHover = false;
			// this.ixColrButHover = -1;
			// this.ixBckgButHover = -1;
			this.ixZoSwButHover = -1;
			this.isDPI300Hover = false;
			this.isSaveFileHover = false;
			break;
		case K.viewsSTEP:
			// this.ixStepButHover = -1; commented out because possible in all states
			this.ixPresButHover = -1;
			this.isReCenterHover = false;
			this.ixColrButHover = -1;
			this.ixBckgButHover = -1;
			// this.ixZoSwButHover = -1;
			// this.isDPI300Hover = false;
			// this.isSaveFileHover = false;
			break;
		default:
			/* do nothing */
			break;
		}
	}

	// /////////////////////////////////////////////////////////////////////////
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// /////////////////////////////////////////////////////////////////////////

	int recordActiveButtonIfHover(final float mouseX, final float mouseY) {

		int ixStepHoverOld = this.ixStepButHover; // before test forHover
		int ixPresHoverOld = this.ixPresButHover;
		int ixColrHoverOld = this.ixColrButHover;
		int ixBckgHoverOld = this.ixBckgButHover;
		int ixZoSwHoverOld = this.ixZoSwButHover;

		int actionIfPressed = testForHoverOverButtons(mouseX, mouseY); // changes ixHover ....

		switch (actionIfPressed) { // action reset after test

		case K.no_____ACTION:
			/* do nothing */
			break;
		case K.newStepACTION:
			int ixOnOld = K.ixStepButOn;
			K.ixStepButOn = this.ixStepButHover; // <=== only place where this is set!
			if ((ixStepHoverOld > -1) && (ixStepHoverOld != this.ixStepButHover) && (ixStepHoverOld != K.ixStepButOn)) {
				drawStepButton(ixStepHoverOld);
			}
			drawStepButton(ixOnOld);
			drawStepButton(K.ixStepButOn);

			if (K.ixStepButOn != ixOnOld) { // re-clicked on other than active

				this.fillDashBottom(); // erase dash on change

				switch (K.ixStepButOn) {
				case K.shapeSTEP:
					this.drawShapePresetButtons();
					this.drawSetShapeInstructions();
					break;
				case K.colorSTEP:
					this.drawColorAndBackgroundButtons();
					this.drawZoomInstructions();
					this.drawReCenterButton(true);
					break;
				case K.viewsSTEP:
					this.drawViewInstructions();
					this.drawViewZoomAndSwatchButtons();
					this.drawDPI300Button(true);
					this.drawSaveFileButton(true);
					break;
				default:
					/* do nothing */
					break;

				}
				return K.newStepACTION; // stepACTION
			}
			break;
		case K.presetsACTION:
			ixOnOld = K.ixPresetButOn;
			K.ixPresetButOn = this.ixPresButHover;
			if ((ixPresHoverOld > -1) && (ixPresHoverOld != this.ixPresButHover) && (ixPresHoverOld != K.ixPresetButOn)) {
				drawShapePresetButton(ixPresHoverOld);
			}
			drawShapePresetButton(ixOnOld);
			drawShapePresetButton(K.ixPresetButOn);
			if (K.ixPresetButOn != ixOnOld) { // changed preset
				return K.presetsACTION; // presetACTION
			}
			break;
		case K.colors_ACTION:
			ixOnOld = KColor.ixColrButOn;
			KColor.ixColrButOn = this.ixColrButHover;
			if ((ixColrHoverOld > -1) && (ixColrHoverOld != this.ixColrButHover)
					&& (ixColrHoverOld != KColor.ixColrButOn)) {
				drawColrButton(ixColrHoverOld, false);
			}
			drawColrButton(ixOnOld, false);
			drawColrButton(KColor.ixColrButOn, false);
			if (KColor.ixColrButOn != ixOnOld) { // changed color
				return K.colors_ACTION; // colorACTION
			}
			break;
		case K.bckgrndACTION:
			ixOnOld = KColor.ixBckgButOn;
			KColor.ixBckgButOn = this.ixBckgButHover;
			if ((ixBckgHoverOld > -1) && (ixBckgHoverOld != this.ixBckgButHover)
					&& (ixBckgHoverOld != KColor.ixBckgButOn)) {
				drawBckgButton(ixBckgHoverOld, false);
			}
			drawBckgButton(ixOnOld, false);
			drawBckgButton(KColor.ixBckgButOn, false);
			if (KColor.ixBckgButOn != ixOnOld) {
				return K.bckgrndACTION; // bckgrdACTION
			}
			break;
		case K.reCentrACTION:
			K.isReCenterOn = true;
			drawReCenterButton(false);
			return K.reCentrACTION; // reCenterACTION
			/* warning no break */
		case K.zooSwtcACTION:
			ixOnOld = K.ixZoomSwatchButOn;
			K.ixZoomSwatchButOn = this.ixZoSwButHover;
			if ((ixZoSwHoverOld > -1) && (ixZoSwHoverOld != this.ixZoSwButHover)
					&& (ixZoSwHoverOld != K.ixZoomSwatchButOn)) {
				drawColrButton(ixZoSwHoverOld, false);
			}
			drawZoomOrSwatchButton(ixOnOld, false);
			drawZoomOrSwatchButton(K.ixZoomSwatchButOn, false);
			if (K.ixZoomSwatchButOn != ixOnOld) { // changed color
				return K.zooSwtcACTION; // zoomSwatchACTION
			}
			break;
		case K.dpi300_ACTION:
			K.isDPI300on = !K.isDPI300on; // Just toggle
			drawDPI300Button(false);
			return K.dpi300_ACTION; // dpi300ACTION
			/* no break as excapes via return */
		case K.savFileACTION:
			if ((Main.isAPPLIC) && ((K.saveFileState == K.inactiveSAVEFILE) || (K.saveFileState == K.doneSAVEFILE))) {
				drawSaveFileButton(false);
				K.saveFileState = K.readyToSAVEFILE;
				return K.savFileACTION; // saveFileACTION
			}
			break;
		default:
			/* do nothing */
			break;
		}
		return K.no_____ACTION; // defaults to no action
	}

	// /////////////////////////////////////////////////////////////////////////
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// /////////////////////////////////////////////////////////////////////////

	int testForHoverOverButtons(final float mouseX, final float mouseY) { // return action if Pressed

		clearSupeerfluousHovers();
		this.isFPShover = false;
		int ixStepHover = -1; // no hover

		// ----- first test STEP button area
		if ((mouseY > sepWide) && (mouseY < stepButAreaHeight)) { // in upper area

			if ((mouseX >= BUTxLft) && (mouseX <= BUTxRgt)) { // withing step collumn

				int ixStepBut = Math.min(K.totalSTEPS - 1, (int) ((mouseY - sepWide) / BUTheight));
				float yButArea = mouseY - sepWide - ixStepBut * BUTheight;
				float y2 = BUTheight - sepThin;
				if (yButArea <= y2) {
					if (ixStepBut == K.viewsSTEP) { // rectangular button

						float y1 = 3.0f * y2 / 4.0f;
						if (yButArea <= y1) {
							ixStepHover = ixStepBut;
						}
					} else { // arrow shape buttons

						float y1 = y2 / 2.0f;
						if (yButArea <= y1) {
							ixStepHover = ixStepBut; // inside top rectangular portion
						} else if (((Math.abs(BUTxMid - mouseX) / (BUTxMid - BUTxLft))) < ((y2 - yButArea) / (y2 - y1))) {
							ixStepHover = ixStepBut; // inside bot triangular portion
						}
					}
				}
			}
			if (this.ixStepButHover != ixStepHover) {
				int ixStepHoverOld = this.ixStepButHover;
				this.ixStepButHover = ixStepHover;
				drawStepButton(ixStepHoverOld);
				drawStepButton(ixStepHover);
			}
			if (this.ixStepButHover > -1) {
				return K.newStepACTION; // this is the action that should be executed if pressed
			}

		} else if (K.ixStepButOn == K.shapeSTEP) {

			int ixPresetHover = -1; // no hover
			float y0 = buttonY0(presetButtonROW);
			if ((mouseY >= y0) && (mouseY <= (y0 + sepWide))) {
				// ----- then test preset button area
				float mouseXinPresetX00 = mouseX - BUTxLft;
				float butAreaWidth = buttonX0(1) - buttonX0(0);
				if ((mouseX >= BUTxLft) && (mouseX <= BUTxRgt)) {
					int ixPresetButton = Math.min(K.totalPRESETS - 1, (int) (mouseXinPresetX00 / butAreaWidth));
					float xButArea = mouseXinPresetX00 - ixPresetButton * butAreaWidth;
					if (xButArea <= sepWide) {
						ixPresetHover = ixPresetButton;
					}
				}
			}
			if (this.ixPresButHover != ixPresetHover) {
				int ixPresetButOld = this.ixPresButHover;
				this.ixPresButHover = ixPresetHover;
				drawShapePresetButton(ixPresetButOld);
				drawShapePresetButton(ixPresetHover);
			}

			if (this.ixPresButHover > -1) {
				return K.presetsACTION;
			}

		} else if (K.ixStepButOn == K.colorSTEP) {

			int ixColorHover = -1;
			int ixBckgrndHover = -1;
			this.isReCenterHover = false;
			if ((mouseX >= BUTxLft) && (mouseX <= (BUTxLft + sepWide))) {
				// ----- then test color button area
				float mouseYinColorY00 = mouseY - buttonY0(colorButtonROW);
				float mouseYinBckgrndY00 = mouseY - buttonY0(bckgrndButtonROW);
				float butAreaHeight = sepBoth;
				if ((mouseYinColorY00 >= 0)
						&& (mouseY <= ((buttonY0(colorButtonROW + KColor.totalCOLORS - 1) + sepWide)))) {
					int ixColorButton = Math.min(KColor.totalCOLORS - 1, (int) (mouseYinColorY00 / butAreaHeight));
					float yButArea = mouseYinColorY00 - ixColorButton * butAreaHeight;
					if (yButArea <= sepWide) {
						ixColorHover = ixColorButton;
					}
					// ----- then test background button area
				} else if ((mouseYinBckgrndY00 >= 0)
						&& (mouseY <= (buttonY0(bckgrndButtonROW + KColor.totalBCKGRNDS - 1) + sepWide))) {
					int ixBckgrndButton = Math
							.min(KColor.totalBCKGRNDS - 1, (int) (mouseYinBckgrndY00 / butAreaHeight));
					float yButArea = mouseYinBckgrndY00 - ixBckgrndButton * butAreaHeight;
					if (yButArea <= sepWide) {
						ixBckgrndHover = ixBckgrndButton;
					}
				} else if ((mouseY >= buttonY0(reCenterButtonROW) && (mouseY <= (buttonY0(reCenterButtonROW) + sepWide)))) {
					this.isReCenterHover = true;
				}
			}
			if (this.ixColrButHover != ixColorHover) {
				int ixColorHoverOld = this.ixColrButHover;
				this.ixColrButHover = ixColorHover;
				drawColrButton(ixColorHoverOld, false);
				drawColrButton(ixColorHover, false);
			}
			if (this.ixColrButHover > -1) {
				return K.colors_ACTION;
			}
			if (this.ixBckgButHover != ixBckgrndHover) {
				int ixBckgrndHoverOld = this.ixBckgButHover;
				this.ixBckgButHover = ixBckgrndHover;
				drawBckgButton(ixBckgrndHoverOld, false);
				drawBckgButton(ixBckgrndHover, false);
			}
			if (this.ixBckgButHover > -1) {
				return K.bckgrndACTION;
			}
			if ((this.isReCenterHover != this.isReCenterHoverAsOfLastDrawn)
					|| (K.isReCenterOn != this.isReCenterOnAsOfLastDrawn)) {
				drawReCenterButton(false);
			}
			if (this.isReCenterHover) {
				return K.reCentrACTION;
			}

		} else if (K.ixStepButOn == K.viewsSTEP) {

			int ixZoomOrSwatchHover = -1;
			this.isDPI300Hover = false;
			this.isSaveFileHover = false;
			float zoomX0 = BUTxLft + sepBoth;
			if ((mouseX >= BUTxLft) && (mouseX <= (BUTxLft + sepWide))) { // swatch col
				float mouseYinSwatchY10 = mouseY - buttonY0(1 + zoomButtonROW); // note that starts in index 1
				float bottomButtonY10 = buttonY0(1 + zoomButtonROW + K.ixViewSw100x - K.ixViewZo100x);
				float butAreaHeight = sepBoth;
				if ((mouseYinSwatchY10 >= 0) && (mouseY <= (bottomButtonY10 + sepWide))) {
					int ixSwatchButton0toN = Math.min(K.ixViewTOTAL - K.ixViewSwat3x,
							1 + (int) (mouseYinSwatchY10 / butAreaHeight));
					float yButArea = mouseYinSwatchY10 - (ixSwatchButton0toN - 1) * butAreaHeight;
					if (yButArea <= sepWide) {
						ixZoomOrSwatchHover = ixSwatchButton0toN + K.ixViewZo100x;
					}
				} else if ((mouseY >= buttonY0(dpi300ButtonROW) && (mouseY <= (buttonY0(dpi300ButtonROW) + sepWide)))) {
					this.isDPI300Hover = true;
				} else if ((mouseY >= buttonY0(saveFileButtonROW) && (mouseY <= (buttonY0(saveFileButtonROW) + sepWide)))) {
					this.isSaveFileHover = true;
				}
			} else if ((mouseX >= zoomX0) && (mouseX <= (zoomX0 + sepWide))) { // zoom buttons
				float mouseYinZoomY00 = mouseY - buttonY0(zoomButtonROW);
				float butAreaHeight = sepBoth;
				if ((mouseYinZoomY00 >= 0) && (mouseY <= ((buttonY0(K.ixViewTOTAL - 1) + sepWide)))) {
					int ixZoomButton = Math.min(K.ixViewTOTAL - 1, (int) (mouseYinZoomY00 / butAreaHeight));
					float yButArea = mouseYinZoomY00 - ixZoomButton * butAreaHeight;
					if (yButArea <= sepWide) {
						ixZoomOrSwatchHover = ixZoomButton;
					}
				}
			}
			if (this.ixZoSwButHover != ixZoomOrSwatchHover) {
				int ixZoomHoverOld = this.ixZoSwButHover;
				this.ixZoSwButHover = ixZoomOrSwatchHover;
				drawZoomOrSwatchButton(ixZoomHoverOld, false);
				drawZoomOrSwatchButton(ixZoomOrSwatchHover, false);
			}
			if (this.ixZoSwButHover > -1) {
				return K.zooSwtcACTION;
			}

			if ((this.isDPI300Hover != this.isDPI300HoverAsOfLastDrawn)
					|| (K.isDPI300on != this.isDPI300onAsOfLastDrawn)) {
				drawDPI300Button(false);
			}
			if (this.isDPI300Hover) {
				return K.dpi300_ACTION;
			}

			if ((this.isSaveFileHover != this.isSaveFileHoverAsOfLastDrawn)
					|| (K.saveFileState != this.saveFileStateAsOfLastDrawn)) {
				drawSaveFileButton(false);
			}
			if (this.isSaveFileHover) {
				return K.savFileACTION;
			}
		}
		if (K.ixStepButOn > K.shapeSTEP) {
			this.isFPShover = ((mouseY >= (K.canvasScale - sepWid2)) && (mouseY <= (K.canvasScale - sepWide))
					&& (mouseX >= BUTxLft) && (mouseX <= BUTxRgt));
		}
		return K.no_____ACTION;
	}

	// /////////////////////////////////////////////////////////////////////////
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// /////////////////////////////////////////////////////////////////////////

	void repaintSetShapeStateDash() {

		this.papplet.noStroke();
		this.papplet.fill(182, 73, 38);
		this.papplet.rect(K.dash_x0, 0, K.dash_x0 + dashWidth, K.canvasScale);

		for (int ixButton = 0; ixButton < K.totalSTEPS; ixButton++) {
			this.drawStepButton(ixButton);
		}
		this.drawSetShapeInstructions();
		this.drawShapePresetButtons();
	}

	void repaintViewStateDash() {

		this.papplet.noStroke();
		this.papplet.fill(182, 73, 38);
		this.papplet.rect(K.dash_x0, 0, K.dash_x0 + dashWidth, K.canvasScale);

		for (int ixButton = 0; ixButton < K.totalSTEPS; ixButton++) {
			this.drawStepButton(ixButton);
		}
		this.drawViewInstructions();
		this.drawViewZoomAndSwatchButtons();
		this.drawDPI300Button(true);
		writeFacets();
		this.drawSaveFileButton(true);
	}

	void writeFacets() {

		float x0 = BUTxLft;
		float y0 = buttonY0(dpi300ButtonROW + 1);
		this.papplet.fill(182, 73, 38);
		this.papplet.rect(x0, y0, BUTwidth - sepWide, sepWide);

		this.papplet.fill(255, 197, 94);
		int facets = K.numberOfFacetsResultingInFacetWidthOfOnePixel();
		if (K.isDPI300on && (facets == 1)) {
			this.papplet.text("Now " + facets + " facet (300dpi)", x0 + 8, y0 + sepThin);
		} else if (K.isDPI300on) {
			this.papplet.text("Now " +facets + " facets (300dpi)", x0 + 8, y0 + sepThin);
		} else if (facets == 1) {
			this.papplet.text("Now " + facets + " facet (100dpi)", x0 + 8, y0 + sepThin);
		} else {
			this.papplet.text("Now " + facets + " facets (100dpi)", x0 + 8, y0 + sepThin);
		}
	}

	void writeSaveFileMessageIfNecessary() {

		this.papplet.noStroke();
		this.papplet.fill(182, 73, 38);// color of dash
		this.papplet.rect(K.dash_x0 + sepWide, K.canvasScale - 3.0f * sepWide, BUTwidth, sepWide);

		switch (K.saveFileState) {

		case K.performingSAVEFILE:
			this.papplet.fill(0, 0, 0);
			this.papplet.text("WAIT! Saving file.", BUTxLft, K.canvasScale - sepWid2 - 5);
			break;
		case K.doneSAVEFILE:
			this.papplet.fill(0, 0, 0);
			this.papplet.text("DONE saving file.", BUTxLft, K.canvasScale - sepWid2 - 5);
			break;
		case K.inactiveSAVEFILE:
		case K.readyToSAVEFILE:
		default:
			/* do nothing */
			break;
		}
	}

	void drawFPS(final float fps, final boolean isWorkedThisCycle) {

		this.papplet.noStroke();
		if ((!isWorkedThisCycle) || (K.ixStepButOn == K.shapeSTEP)) { // fill with color of dash
			this.papplet.fill(182, 73, 38);// color of dash
			this.papplet.rect(K.dash_x0 + sepWide, K.canvasScale - sepWid2, BUTwidth, sepWide);
		} else { // show progress
			float x0 = K.dash_x0 + sepWide;
			float x2 = x0 + BUTwidth;
			float x1 = x0 + BUTwidth * K.currentChildBeingDrawn / Buffer.numberOfStrandsTRAVERSED;
			this.papplet.fill(231, 142, 52);
			this.papplet.rect(x0, K.canvasScale - sepWid2, x1 - x0, sepWide);
			this.papplet.fill(142, 40, 0); // receding time bar
			this.papplet.rect(x1, K.canvasScale - sepWid2, x2 - x1, sepWide);
		}

		if (this.isFPShover) {
			this.papplet.fill(255, 197, 94);
			this.papplet.text((int) (fps + 0.5f), BUTxMid - 10, K.canvasScale - sepWide - 5);
		}
	}

	// ////////////////////////////////////////////////////////////////////////
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// ////////////////////////////////////////////////////////////////////////

	// ========================================================================
	// Private methods
	// ========================================================================

	private void drawSetShapeInstructions() {

		float y0 = stepButAreaHeight + 25;

		this.papplet.fill(0, 0, 0);

		this.papplet.text("Red, blue and purple disks", BUTxLft, y0);
		this.papplet.text("control strand shape.", BUTxLft, y0 + sepWide);
		this.papplet.text("Try moving them here", BUTxLft, y0 + 2 * sepWide);

		this.papplet.text("Red and blue disks affect", BUTxLft, y0 + 4 * sepWide);
		this.papplet.text("ends of strand. Purple", BUTxLft, y0 + 5 * sepWide);
		this.papplet.text("disk affects whole strand.", BUTxLft, y0 + 6 * sepWide);

		this.papplet.text("Vertical move changes", BUTxLft, y0 + 8 * sepWide);
		this.papplet.text("depth of waves.", BUTxLft, y0 + 9 * sepWide);

		this.papplet.text("Horizontal move changes", BUTxLft, y0 + 10 * sepWide);
		this.papplet.text("length of waves. Moving", BUTxLft, y0 + 11 * sepWide);
		this.papplet.text("right shortens waves.", BUTxLft, y0 + 12 * sepWide);

		this.papplet.text("Moving green disk up", BUTxLft, y0 + 14 * sepWide);
		this.papplet.text("and down changes", BUTxLft, y0 + 15 * sepWide);
		this.papplet.text("strand orientation.", BUTxLft, y0 + 16 * sepWide);

		this.papplet.text("Presets", BUTxLft + 54, buttonY0(presetButtonROW) - 8);

		this.papplet.stroke(0);
		this.papplet.line(BUTxRgt - 8, K.canvasScale / 2.0f, BUTxRgt + 16, K.canvasScale / 2.0f);
		this.papplet.line(BUTxRgt + 8, K.canvasScale / 2.0f - 8.0f, BUTxRgt + 16, K.canvasScale / 2.0f);
		this.papplet.line(BUTxRgt + 8, K.canvasScale / 2.0f + 8.0f, BUTxRgt + 16, K.canvasScale / 2.0f);
		this.papplet.noStroke();
	}

	private void drawZoomInstructions() {
		float y0 = stepButAreaHeight + 17.0f * sepWide;
		this.papplet.text("To select zoom region", BUTxLft, y0);
		this.papplet.text("for Step 3, drag", BUTxLft, y0 + sepWide);
		this.papplet.text("the 10x reticle.", BUTxLft, y0 + 2 * sepWide);
	}

	private void drawViewInstructions() {
		float y0 = stepButAreaHeight + zoomButtonROW * sepBoth - sepThin;
		this.papplet.fill(0, 0, 0);
		this.papplet.text("Swatch", BUTxLft + sepBoth + sepWide + 8, y0);
		this.papplet.text("Fill canvas", BUTxLft + sepBoth + sepWide + 8, y0 + sepBoth);
		this.papplet.stroke(0);
		this.papplet.line(BUTxLft + sepThin, y0 - 6, BUTxLft + sepBoth + sepWide + 2, y0 - 6);
		this.papplet.line(BUTxLft + sepThin, y0 - 6, BUTxLft + sepThin, y0 + 2 * sepBoth + sepThin + 4);
		this.papplet.line(BUTxLft + sepBoth + sepThin, y0 + sepBoth - 6, BUTxLft + sepBoth + sepWide + 2, y0 + sepBoth
				- 6);
		this.papplet.line(BUTxLft + sepBoth + sepThin, y0 + sepBoth - 6, BUTxLft + sepBoth + sepThin, y0 + sepBoth
				+ sepThin + 4);
		this.papplet.noStroke();

		if (!Main.isAPPLIC) { // if Applet, disable Save File
			y0 = buttonY0(saveFileButtonROW + 1);
			this.papplet.text("Button disabled. Download", sepThin, y0 + sepThin);
			this.papplet.text("application to save file.", sepThin, y0 + sepBoth);
		}
	}

	private void drawStepButton(final int ixButton) { // ixButton = 0..3

		if (ixButton > -1) {
			float y0 = sepWide + ixButton * BUTheight;
			float y2 = y0 + BUTheight - sepThin;
			float y1 = (y0 + 2.0f * y2) / 3.0f;

			this.buttonFillColor(this.ixStepButHover == ixButton, K.ixStepButOn == ixButton);

			this.papplet.beginShape();
			this.papplet.vertex(BUTxLft, y0);
			this.papplet.vertex(BUTxRgt, y0);
			if (ixButton == K.viewsSTEP) {
				this.papplet.vertex(BUTxRgt, (y1 + y2) / 2.0f);
				this.papplet.vertex(BUTxLft, (y1 + y2) / 2.0f);
			} else {
				this.papplet.vertex(BUTxRgt, y1);
				this.papplet.vertex(BUTxMid, y2);
				this.papplet.vertex(BUTxLft, y1);
			}
			this.papplet.vertex(BUTxLft, y0);
			this.papplet.endShape();

			if ((this.ixStepButHover == ixButton) || (K.ixStepButOn == ixButton)) {
				this.papplet.fill(0, 0, 0);
			} else {
				this.papplet.fill(255, 240, 165); // Dark background
			}
			float x0 = BUTxLft + adjButTxt[Main.ixSIZE] + 12;
			this.papplet.text(K.stepButtonStr1[ixButton], x0, y0 + sepWide + 2);
			this.papplet.text(K.stepButtonStr2[ixButton], x0, y0 + 2 * sepWide + 2);
			this.papplet.text(K.stepButtonStr3[ixButton], x0, y0 + 3 * sepWide + 2);
		}
	}

	private void fillDashBottom() {
		this.papplet.noStroke();
		this.papplet.fill(182, 73, 38);
		this.papplet.rect(K.dash_x0, stepButAreaHeight, dashWidth, K.canvasScale - sepWid2 - stepButAreaHeight);
	}

	private void drawShapePresetButtons() {

		for (int ixButton = 0; ixButton < K.totalPRESETS; ixButton++) {
			this.drawShapePresetButton(ixButton);
		}
	}

	private void drawShapePresetButton(final int ixButton) {

		if (ixButton > -1) {
			float x0 = buttonX0(ixButton);
			float y0 = buttonY0(presetButtonROW);
			this.buttonFillColor(ixButton, this.ixPresButHover, K.ixPresetButOn, x0, y0);
		}
	}

	private void drawColorAndBackgroundButtons() {
		for (int ixButton = 0; ixButton < KColor.totalCOLORS; ixButton++) {
			this.drawColrButton(ixButton, true);
		}
		for (int ixButton = 0; ixButton < KColor.totalBCKGRNDS; ixButton++) {
			this.drawBckgButton(ixButton, true);
		}
	}

	private void drawColrButton(final int ixButton, final boolean isTextAlso) {

		if (ixButton > -1) {
			float y0 = buttonY0(colorButtonROW + ixButton);
			this.buttonFillColor(ixButton, this.ixColrButHover, KColor.ixColrButOn, BUTxLft, y0);
			if (isTextAlso) {
				this.papplet.fill(0, 0, 0);
				this.papplet.text(KColor.colorButtonStr[ixButton], BUTxLft + sepWide + 8, y0 + sepThin + 5);
			}
		}
	}

	private void drawBckgButton(final int ixButton, final boolean isTextAlso) {

		if (ixButton > -1) {
			float y0 = buttonY0(bckgrndButtonROW + ixButton);
			this.buttonFillColor(ixButton, this.ixBckgButHover, KColor.ixBckgButOn, BUTxLft, y0);
			if (isTextAlso) {
				this.papplet.fill(0, 0, 0);
				this.papplet.text(KColor.bckgrndButtonStr[ixButton], BUTxLft + sepWide + 8, y0 + sepThin + 5);
			}
		}
	}

	private void drawReCenterButton(final boolean isTextAlso) {

		float y0 = buttonY0(reCenterButtonROW);
		this.paintButton(this.isReCenterHover, K.isReCenterOn, BUTxLft, y0);
		if (isTextAlso) {
			this.papplet.fill(0, 0, 0);
			this.papplet.text("Re-center drawing", BUTxLft + sepWide + 8, y0 + sepThin + 5);
		}
		this.isReCenterHoverAsOfLastDrawn = this.isReCenterHover;
		this.isReCenterOnAsOfLastDrawn = K.isReCenterOn;
	}

	private void drawViewZoomAndSwatchButtons() {
		for (int ixButton = 0; ixButton < K.ixViewTOTAL; ixButton++) {
			this.drawZoomOrSwatchButton(ixButton, true);
		}
	}

	private void drawZoomOrSwatchButton(final int ixButton, final boolean isTextAlso) {

		if (ixButton > K.ixViewZo100x) {
			float x0 = BUTxLft;
			float y0 = buttonY0(ixButton - K.ixViewZo100x + zoomButtonROW); // thus minimum is row one
			this.buttonFillColor(ixButton, this.ixZoSwButHover, K.ixZoomSwatchButOn, x0, y0);
		} else if (ixButton > -1) {
			float x0 = BUTxLft + sepBoth;
			float y0 = buttonY0(ixButton + zoomButtonROW);
			this.buttonFillColor(ixButton, this.ixZoSwButHover, K.ixZoomSwatchButOn, x0, y0);
			if (isTextAlso) {
				this.papplet.fill(0, 0, 0);
				this.papplet.text(K.zoomButStr[ixButton], BUTxLft + sepBoth + sepWide + 8, y0 + sepThin + 5);
			}
		}
	}

	private void drawDPI300Button(final boolean isTextAlso) {

		float y0 = buttonY0(dpi300ButtonROW);
		this.paintButton(this.isDPI300Hover, K.isDPI300on, BUTxLft, y0);
		if (isTextAlso) {
			this.papplet.fill(0, 0, 0);
			this.papplet.text("Higher resolution", BUTxLft + sepWide + 8, y0 + sepThin + 5);
		}
		this.isDPI300HoverAsOfLastDrawn = this.isDPI300Hover;
		this.isDPI300onAsOfLastDrawn = K.isDPI300on;
	}

	private void drawSaveFileButton(final boolean isTextAlso) {

		float y0 = buttonY0(saveFileButtonROW);
		if (Main.isAPPLIC) {
			boolean isOn = (K.saveFileState == K.readyToSAVEFILE) || (K.saveFileState == K.performingSAVEFILE);
			this.paintButton(this.isSaveFileHover, isOn, BUTxLft, y0);
		} else { // disable button in Applet mode
			this.papplet.fill(0, 0, 0);
			this.papplet.rect(BUTxLft, y0, sepWide, sepWide);
		}
		if (isTextAlso) {
			this.papplet.fill(0, 0, 0);
			this.papplet.text("Save drawing (PS)", BUTxLft + sepWide + 8, y0 + sepThin + 5);
		}
		this.isSaveFileHoverAsOfLastDrawn = this.isSaveFileHover;
		this.saveFileStateAsOfLastDrawn = K.saveFileState;
	}

	// ========================================================================
	// Drawing support methods
	// ========================================================================

	private void paintButton(final boolean isHover, final boolean isOn, final float x0, final float y0) {

		this.buttonFillColor(isHover, isOn);
		this.papplet.rect(x0, y0, sepWide, sepWide);
	}

	private void buttonFillColor(final int ixBut_, final int ixHover_, final int ixOn_, final float x0, final float y0) {

		this.buttonFillColor(ixHover_ == ixBut_, ixOn_ == ixBut_);
		this.papplet.rect(x0, y0, sepWide, sepWide);
	}

	private void buttonFillColor(final boolean isHover, final boolean isOn) {

		if (isHover) {
			if (isOn) {
				this.papplet.fill(255, 240, 165);
			} else {
				this.papplet.fill(231, 142, 52);
			}
		} else if (isOn) {
			this.papplet.fill(255, 197, 94);
		} else {
			this.papplet.fill(142, 40, 0);
		}
		this.papplet.noStroke();
	}

	private float buttonX0(final int col) {
		float butSep = (BUTxRgt - BUTxLft - sepWide) / (K.totalPRESETS - 1) - sepWide;
		return BUTxLft + col * (sepWide + butSep);
	}

	private float buttonY0(final int row) {
		return stepButAreaHeight + sepWid2 + row * sepBoth;
	}

	// ========================================================================
	// DEBUG
	// ========================================================================
	void debug(final String mesg) { // Public so that does not trigger warning when unused
		DebugUtil.printDebugMessage(this.getClass(), mesg);
	}
}
