// ===================================================
// hairSynth - a simple vector graphics hair generator
// Copyright (C) 2007 JM Bara <http://www.codemuse.net>
// See licence terms in file "READ ME"
// ===================================================
// Uses Processing <http://processing.org>
// Uses SimplePostscript v.0092 <http:www.unlekker.net>
// ===================================================

/*****************************************************
 * class BufferSingle includes the methods that draw
 * the master hair strand on Step 1 (set shape)
 */

package hairSynth;

import processing.core.PApplet;

final class BufferSingle extends Buffer {

	private Strand strand;

	BufferSingle(final PApplet papplet_) {

		createPG(papplet_);

		this.strand = new Strand(-1); // arbitrary but does not conflict with other IDs
		this.strand.clearDeltaHSBandCat5color();
	}

	Strand getStrand() {
		return this.strand;
	}

	void setParamsFromDiskXYPositions(final int ixDisk, final float activeX, final float activeY) {

		// ---- convert X (period) from 10 ... 790 to 2.0 ... 0.2
		float exp = K.LN4 + (activeX - K.diskRADIUS) * (K.LN04 - K.LN4) / (K.canvasScale - 2.0f * K.diskRADIUS);
		float period = (float) Math.exp(exp);

		// ---- convert Y (radius) from 10 ... 790 to -2.0 .... +2.0 ... rad also used to compute Normal angle
		float rad = 2.0f - (activeY - K.diskRADIUS) * 4.0f / (K.canvasScale - 2.0f * K.diskRADIUS);

		switch (ixDisk) {
		case K.ixOscBLU0:
			this.strand.setOscParams(ixDisk, period, rad, 0.0);
			break;
		case K.ixOscMAG1:
			this.strand.setOscParams(ixDisk, period, rad, rad);
			break;
		case K.ixOscRED2:
			this.strand.setOscParams(ixDisk, period, 0.0, rad);
			break;
		case K.ixDirGRN3:
			this.strand.setFace1nInit(rad * K.PI05);
			break;
		default:
			/* do nothing */
			break;
		}
		K.diskParamCodeInt[ixDisk] = (int) activeY * 100 + (int) activeX; // 100^8 fits easily in 2^63
		// ----- note that oscParamCodeLong uses zeros as positions for unchanged disks
		K.oscParamCodeLong = K.diskParamCodeInt[K.ixOscBLU0] * 10000 * 10000 * 10000
				+ K.diskParamCodeInt[K.ixOscMAG1] * 10000 * 10000 //
				+ K.diskParamCodeInt[K.ixOscRED2] * 10000 //
				+ K.diskParamCodeInt[K.ixDirGRN3];
	}

	boolean drawSingleStrand() {

		this.pg.beginDraw();
		this.pg.background(0);
		if (Main.isAPPLIC) {
			this.pg.stroke(182, 73, 38);
			this.pg.line(0, 0, K.canvasScale-1, 0);
			this.pg.line(0, K.canvasScale-1, K.canvasScale-1, K.canvasScale-1);
			this.pg.line(0 + K.canvasScale-1, 0, K.canvasScale-1, K.canvasScale-1);
		}

		double dist = 0.0;
		this.strand.setPositionDxDyInit();

		float tmpBoxLft = 0.0f; // set to initial strand position
		float tmpBoxRgt = 0.0f;
		float tmpBoxTop = 1.0f;
		float tmpBoxBot = 1.0f;

		while (dist < K.totalStrandLEN) {

			double dist0to1 = dist / K.totalStrandLEN;
			int red = 64 + (int) (191.999 * dist0to1);
			int blu = 255 - (int) (255.999 * dist0to1);
			this.pg.stroke(red, blu / 2, blu);

			dist = this.strand.nextSegment(dist);

			float face0X = this.strand.getFace0Xfloat();
			float face0Y = this.strand.getFace0Yfloat();
			float face1X = this.strand.getFace1Xfloat();
			float face1Y = this.strand.getFace1Yfloat();

			if (tmpBoxLft > face1X) {
				tmpBoxLft = face1X;
			}

			if (tmpBoxRgt < face1X) {
				tmpBoxRgt = face1X;
			}

			if (tmpBoxBot > face1Y) {
				tmpBoxBot = face1Y;
			}

			if (tmpBoxTop < face1Y) {
				tmpBoxTop = face1Y;
			}

			this.pg.line(K.canvasSinglXpixEased(face0X), K.canvasSinglYpixEased(face0Y),
					K.canvasSinglXpixEased(face1X), K.canvasSinglYpixEased(face1Y));
		}
		this.pg.endDraw();

		return K.setBoxSingleXYandScaleAndReturnIsEasing(tmpBoxLft, tmpBoxRgt, tmpBoxBot, tmpBoxTop);
	}
}
