// ===================================================
// hairSynth - a simple vector graphics hair generator
// Copyright (C) 2007 JM Bara <http://www.codemuse.net>
// See licence terms in file "READ ME"
// ===================================================
// Uses Processing <http://processing.org>
// Uses SimplePostscript v.0092 <http:www.unlekker.net>
// ===================================================

/*****************************************************
 * Class Buffer holds the pGraphics image buffer.
 * Buffer is further extended by classes BufferSingle,
 * BufferBunch, and BufferView.
 */


package hairSynth;

import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;

class Buffer {

	// ===== these are visible as they are used by downstream classes
	// ----- stages of drawing
	static final int stagePOPULATE0 = 0;
	static final int stageINITDRAW1 = 1;
	static final int stageDRAWABUNCH2 = 2;
	static final int stageREFRESHSCREEN3 = 3;
	static final int stageDONE4 = 4;

	int stage = stagePOPULATE0;

	// ----- used array instead of dynamically creating to reuse objects
	static final int maxLEVEL = 10;
	static final float maxLEVEL2fl = maxLEVEL * maxLEVEL;
	static final double maxLEVEL2db = maxLEVEL * maxLEVEL;
	// ----- with Level=10 the number of strands traversed is 2047 and strands drawn is 1024
	static final int numberOfStrandsTRAVERSED = (int) Math.pow(2, maxLEVEL + 1);

	PGraphics pg; // must be visible to extended classes
	PApplet papplet; // must be visible to extended classes

	Buffer() {
		/* do nothing */
	}


	final void createPG(final PApplet papplet_) {
		this.papplet = papplet_;
		this.pg = this.papplet.createGraphics((int) K.canvasScale, (int) K.canvasScale, PConstants.P3D);
	}

	void triggerInitDraw() {
		if (this.stage > stageINITDRAW1) {
			this.stage = stageINITDRAW1; // redraw
		}
	}

	void triggerRefreshScreen() {
		if (this.stage > stageREFRESHSCREEN3) {
			this.stage = stageREFRESHSCREEN3;
		}
	}

	final void copyToScreen() { // this was causing error on buffer view when in applet mode
		this.papplet.image(this.pg, K.canvas_x0, 0);
	}

	final void clearPgScreen() {
		this.pg.beginDraw();
		this.pg.background(KColor.colorBCKGRND[KColor.ixBckgButOn]);
		this.pg.endDraw();
	}

	final void clearPAppletScreen() {

		this.papplet.noStroke();
		this.papplet.fill(KColor.colorBCKGRND[KColor.ixBckgButOn]);
		this.papplet.rect(K.canvas_x0, 0, K.canvasScale, K.canvasScale);
	}
}
