/* This class holds the methods to write to the grid
 *
 * FONT is 04B_03_ copyright Yuji Oshimoto
 * http://www.04.jp.org/
 */

final class Txt {

	static boolean txtGrid[][][] = new boolean[2][K.gridSizeMAX][K.gridSizeMAX];

	private final static int pixBetweenLines = 1;

	private static final boolean[][][] cPix = // note [charIx][j][i]
	{
	// ---- // space
			{ { false, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// !
			{ { true, false, false, false, false }, { true, false, false, false, false },
					{ true, false, false, false, false }, { false, false, false, false, false },
					{ true, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// (
			{ { false, true, false, false, false }, { true, false, false, false, false },
					{ true, false, false, false, false }, { true, false, false, false, false },
					{ true, false, false, false, false }, { false, true, false, false, false },
					{ false, false, false, false, false } },
			// )
			{ { true, false, false, false, false }, { false, true, false, false, false },
					{ false, true, false, false, false }, { false, true, false, false, false },
					{ false, true, false, false, false }, { true, false, false, false, false },
					{ false, false, false, false, false } },
			// *
			{ { false, false, true, false, false }, { true, false, true, false, true },
					{ false, true, false, true, false }, { true, false, false, false, true },
					{ false, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// +
			{ { false, false, false, false, false }, { false, true, false, false, false },
					{ true, true, true, false, false }, { false, true, false, false, false },
					{ false, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// ,
			{ { false, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false }, { false, false, false, false, false },
					{ false, true, false, false, false }, { true, false, false, false, false },
					{ false, false, false, false, false } },
			// -
			{ { false, false, false, false, false }, { false, false, false, false, false },
					{ true, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// .
			{ { false, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false }, { false, false, false, false, false },
					{ true, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// /
			{ { false, false, false, false, false }, { false, false, false, false, true },
					{ false, false, false, true, false }, { false, false, true, false, false },
					{ false, true, false, false, false }, { true, false, false, false, false },
					{ false, false, false, false, false } },
			// 0
			{ { false, true, true, false, false }, { true, false, false, true, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ false, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// 1
			{ { true, true, false, false, false }, { false, true, false, false, false },
					{ false, true, false, false, false }, { false, true, false, false, false },
					{ false, true, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// 2
			{ { true, true, true, false, false }, { false, false, false, true, false },
					{ false, true, true, false, false }, { true, false, false, false, false },
					{ true, true, true, true, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// 3
			{ { true, true, true, false, false }, { false, false, false, true, false },
					{ false, true, true, false, false }, { false, false, false, true, false },
					{ true, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// 4
			{ { false, false, true, false, false }, { false, true, true, false, false },
					{ true, false, true, false, false }, { true, true, true, true, false },
					{ false, false, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// 5
			{ { true, true, true, true, false }, { true, false, false, false, false },
					{ true, true, true, false, false }, { false, false, false, true, false },
					{ true, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// 6
			{ { false, true, true, false, false }, { true, false, false, false, false },
					{ true, true, true, false, false }, { true, false, false, true, false },
					{ false, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// 7
			{ { true, true, true, true, false }, { false, false, false, true, false },
					{ false, false, true, false, false }, { false, true, false, false, false },
					{ false, true, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// 8
			{ { false, true, true, false, false }, { true, false, false, true, false },
					{ false, true, true, false, false }, { true, false, false, true, false },
					{ false, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// 9
			{ { false, true, true, false, false }, { true, false, false, true, false },
					{ false, true, true, true, false }, { false, false, false, true, false },
					{ false, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// :
			{ { false, false, false, false, false }, { true, false, false, false, false },
					{ false, false, false, false, false }, { false, false, false, false, false },
					{ true, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// ;
			{ { false, false, false, false, false }, { false, true, false, false, false },
					{ false, false, false, false, false }, { false, false, false, false, false },
					{ false, true, false, false, false }, { true, false, false, false, false },
					{ false, false, false, false, false } },
			// <
			{ { false, false, true, false, false }, { false, true, false, false, false },
					{ true, false, false, false, false }, { false, true, false, false, false },
					{ false, false, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// =
			{ { false, false, false, false, false }, { true, true, true, false, false },
					{ false, false, false, false, false }, { true, true, true, false, false },
					{ false, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// >
			{ { true, false, false, false, false }, { false, true, false, false, false },
					{ false, false, true, false, false }, { false, true, false, false, false },
					{ true, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// ?
			{ { true, true, true, false, false }, { false, false, false, true, false },
					{ false, true, true, false, false }, { false, false, false, false, false },
					{ false, true, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// a
			{ { false, false, false, false, false }, { false, true, true, true, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ false, true, true, true, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// b
			{ { true, false, false, false, false }, { true, true, true, false, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ true, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// c
			{ { false, false, false, false, false }, { false, true, true, false, false },
					{ true, false, false, false, false }, { true, false, false, false, false },
					{ false, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// d
			{ { false, false, false, true, false }, { false, true, true, true, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ false, true, true, true, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// e
			{ { false, false, false, false, false }, { false, true, true, false, false },
					{ true, false, true, true, false }, { true, true, false, false, false },
					{ false, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// f
			{ { false, false, true, false, false }, { false, true, false, false, false },
					{ true, true, true, false, false }, { false, true, false, false, false },
					{ false, true, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// g
			{ { false, false, false, false, false }, { false, true, true, true, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ false, true, true, true, false }, { false, false, false, true, false },
					{ false, true, true, false, false } },
			// h
			{ { true, false, false, false, false }, { true, true, true, false, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ true, false, false, true, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// i
			{ { true, false, false, false, false }, { false, false, false, false, false },
					{ true, false, false, false, false }, { true, false, false, false, false },
					{ true, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// j
			{ { false, true, false, false, false }, { false, false, false, false, false },
					{ false, true, false, false, false }, { false, true, false, false, false },
					{ false, true, false, false, false }, { false, true, false, false, false },
					{ true, false, false, false, false } },
			// k
			{ { true, false, false, false, false }, { true, false, false, true, false },
					{ true, false, true, false, false }, { true, true, true, false, false },
					{ true, false, false, true, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// l
			{ { true, false, false, false, false }, { true, false, false, false, false },
					{ true, false, false, false, false }, { true, false, false, false, false },
					{ true, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// m
			{ { false, false, false, false, false }, { true, true, true, true, false },
					{ true, false, true, false, true }, { true, false, true, false, true },
					{ true, false, true, false, true }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// n
			{ { false, false, false, false, false }, { true, true, true, false, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ true, false, false, true, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// o
			{ { false, false, false, false, false }, { false, true, true, false, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ false, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// p
			{ { false, false, false, false, false }, { true, true, true, false, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ true, true, true, false, false }, { true, false, false, false, false },
					{ true, false, false, false, false } },
			// q
			{ { false, false, false, false, false }, { false, true, true, true, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ false, true, true, true, false }, { false, false, false, true, false },
					{ false, false, false, true, false } },
			// r
			{ { false, false, false, false, false }, { true, false, true, false, false },
					{ true, true, false, false, false }, { true, false, false, false, false },
					{ true, false, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// s
			{ { false, false, false, false, false }, { false, true, true, true, false },
					{ true, true, false, false, false }, { false, false, true, true, false },
					{ true, true, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// t
			{ { false, true, false, false, false }, { true, true, true, false, false },
					{ false, true, false, false, false }, { false, true, false, false, false },
					{ false, false, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// u
			{ { false, false, false, false, false }, { true, false, false, true, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ false, true, true, true, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// v
			{ { false, false, false, false, false }, { true, false, false, true, false },
					{ true, false, false, true, false }, { true, false, true, false, false },
					{ false, true, false, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// w
			{ { false, false, false, false, false }, { true, false, true, false, true },
					{ true, false, true, false, true }, { false, true, false, true, false },
					{ false, true, false, true, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// x
			{ { false, false, false, false, false }, { true, false, true, false, false },
					{ false, true, false, false, false }, { false, true, false, false, false },
					{ true, false, true, false, false }, { false, false, false, false, false },
					{ false, false, false, false, false } },
			// y
			{ { false, false, false, false, false }, { true, false, false, true, false },
					{ true, false, false, true, false }, { true, false, false, true, false },
					{ false, true, true, true, false }, { false, false, false, true, false },
					{ false, true, true, false, false } },
			// z
			{ { false, false, false, false, false }, { true, true, true, true, false },
					{ false, false, true, false, false }, { false, true, false, false, false },
					{ true, true, true, true, false }, { false, false, false, false, false },
					{ false, false, false, false, false } } };

	private static final int[] cWidht = {
			// sp ! ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? a b c d e f g h i j k l m n o p q r s t u v w x y z
			2, 1, 2, 2, 5, 3, 2, 3, 1, 5, 4, 2, 4, 4, 4, 4, 4, 4, 4, 4, 1, 2, 3, 3, 3, 4, 4, 4, 3, 4, 4, 3, 4, 4, 1, 2,
			4, 1, 5, 4, 4, 4, 4, 3, 4, 3, 4, 4, 5, 3, 4, 4 };

	private Txt() {
		/* empty */
	}

	static final void clearTextGrid(final int gridIx) {
		for (int i = 0; i < K.gridSize; i++) {
			for (int j = 0; j < K.gridSize; j++) {
				txtGrid[gridIx][i][j] = false;
			}
		}
	}

	static final void copyTextGridFromTo(final int from_, final int to_) {
		for (int i = 0; i < K.gridSize; i++) {
			for (int j = 0; j < K.gridSize; j++) {
				txtGrid[to_][i][j] = txtGrid[from_][i][j];
			}
		}
	}

	static final void writeLine1to5(final int gridIx, final int line1to5, final int linesTot, final String str) {

		// -----calculate Ypos0
		int freePixY = K.gridSize - linesTot * 7 - (linesTot - 1) * pixBetweenLines;
		int lineY0 = (line1to5 - 1) * 7 + (freePixY + 3) / 2;

		// -----calculate Xpos0
		int strLen = str.length();
		int freePixX = K.gridSize - strLen + 1;

		for (int cPos = 0; cPos < strLen; cPos++) {
			freePixX -= Txt.cWidht[charIx(str.charAt(cPos))];
		}
		if (freePixX < 0) {
			freePixX = 0;
			System.out.println("ERROR - string " + str + " is too wide!");
		}
		int charX0 = freePixX / 2;

		for (int cPos = 0; cPos < strLen; cPos++) {

			int charIx_ = charIx(str.charAt(cPos));
			int cWidth = Txt.cWidht[charIx_];
			for (int i = 0; i < cWidth; i++) {
				for (int j = 0; j < 7; j++) { // 7 pixel rows

					if (Txt.cPix[charIx_][j][i]) {
						txtGrid[gridIx][i + charX0][j + lineY0] = true;
					}
				}
			}
			charX0 += cWidth + 1; // +1 to allow for separation between letters
		}
	}

	private static final int charIx(final char c) {

		int ascii = c;
		int charIx_ = 4; // default
		if (ascii >= 97) { // 97 is ascii( a )
			if (ascii <= 122) { // 122 is ascii( z )
				charIx_ = ascii - 71; // 71 = 97 - 26 numerical chars in table
			}
		} else if (ascii == 32) { // 32 is ascii( space )
			charIx_ = 0;
		} else if (ascii == 33) { // 33 is ascii( ! )
			charIx_ = 1;
		} else if (ascii <= 63) { // 63 is ascii( ? )
			if (ascii >= 40) { // 40 is ascii( ( )
				charIx_ = ascii - 38;
			}
		}
		return charIx_;
	}
}
