/* this class holds the methods that handle the cuts (rips) in the grid */

import java.text.DecimalFormat;

public class TetraC {

	PointC[] loc = { // used to store corners and cut locations

	new PointC(0.0f, 0.0f, 0, false, 0.0f), new PointC(0.0f, 0.0f, 0, false, 0.0f), new PointC(0.0f, 0.0f, 0, false, 0.0f),
			new PointC(0.0f, 0.0f, 0, false, 0.0f), new PointC(0.0f, 0.0f, 0, false, 0.0f),
			new PointC(0.0f, 0.0f, 0, false, 0.0f), new PointC(0.0f, 0.0f, 0, false, 0.0f),
			new PointC(0.0f, 0.0f, 0, false, 0.0f) };
	int nCutsOut; // used for Grid and Out only
	int shapeCodeOut; // used for Grid and Out only

	// =========================================================================
	private static DecimalFormat myInt = new DecimalFormat("###000 ");
	private static DecimalFormat myDouble3 = new DecimalFormat("##0.000");

	// boolean hasVisiblePoly; // used for In only; set by calc cuts
	// boolean hasPolyWoutTL;

	/** Creates a new instance of TetraClass. */
	public TetraC() {
		// empty //
	}

	public final void setAllLocStatus(final int s) {
		for (int n = 0; n < K.nLOC; n++) {
			this.loc[n].status = s;
		}
	}

	public final void clearLocationCoords() {
		for (int n = 0; n < K.nLOC; n++) {
			this.loc[n].x = 0.0f;
			this.loc[n].y = 0.0f;
			this.loc[n].status = K.NOTSET;
		}
	}

	public final void clear() {
		for (int n = 0; n < K.nLOC; n++) {
			this.loc[n].clear();
		}

		this.nCutsOut = 0;
		this.shapeCodeOut = 0;

		// hasVisiblePoly = false;
	}

	// ===== THESE METHODS USED TO SET GRID =====================================
	public final void copyIsCutCutPosAndXYFromGridNodes(final int i, final int j) {
		this.loc[K.TL].x = Calc.node[i][j].x;
		this.loc[K.TL].y = Calc.node[i][j].y;
		this.loc[K.TR].x = Calc.node[i + 1][j].x;
		this.loc[K.TR].y = Calc.node[i + 1][j].y;
		this.loc[K.BR].x = Calc.node[i + 1][j + 1].x;
		this.loc[K.BR].y = Calc.node[i + 1][j + 1].y;
		this.loc[K.BL].x = Calc.node[i][j + 1].x;
		this.loc[K.BL].y = Calc.node[i][j + 1].y;

		this.nCutsOut = 0;
		this.shapeCodeOut = 0; // no "cuts" (or spring deActivations)

		this.loc[K.TC].isCut = !Calc.node[i][j].isSpringRightActive;

		if (this.loc[K.TC].isCut) {
			this.loc[K.TC].cutFracClock = Calc.node[i][j].springRightStub;
			this.nCutsOut++;
			this.shapeCodeOut += K._shapeCodeTop; // 1 = Top
		}

		this.loc[K.RC].isCut = !Calc.node[i + 1][j].isSpringDownActive;

		if (this.loc[K.RC].isCut) {
			this.loc[K.RC].cutFracClock = Calc.node[i + 1][j].springDownStub;
			this.nCutsOut++;
			this.shapeCodeOut += K._shapeCodeRgt; // 2 = Right
		}

		this.loc[K.BC].isCut = !Calc.node[i][j + 1].isSpringRightActive;

		if (this.loc[K.BC].isCut) {
			this.loc[K.BC].cutFracClock = 1.0f - Calc.node[i][j + 1].springRightStub;
			this.nCutsOut++;
			this.shapeCodeOut += K._shapeCodeBot; // 4 = Bottom
		}

		this.loc[K.LC].isCut = !Calc.node[i][j].isSpringDownActive;

		if (this.loc[K.LC].isCut) {
			this.loc[K.LC].cutFracClock = 1.0f - Calc.node[i][j].springDownStub;
			this.nCutsOut++;
			this.shapeCodeOut += K._shapeCodeLft; // 8 = Left
		}
	}

	public final void copyNCutsShapeCodeAndIsCutSettingsFromTetra(final TetraC grid_) {
		this.nCutsOut = grid_.nCutsOut;
		this.shapeCodeOut = grid_.shapeCodeOut;

		this.loc[K.TC].isCut = grid_.loc[K.TC].isCut;
		this.loc[K.RC].isCut = grid_.loc[K.RC].isCut;
		this.loc[K.BC].isCut = grid_.loc[K.BC].isCut;
		this.loc[K.LC].isCut = grid_.loc[K.LC].isCut;

		this.loc[K.TC].cutFracClock = grid_.loc[K.TC].cutFracClock;
		this.loc[K.RC].cutFracClock = grid_.loc[K.RC].cutFracClock;
		this.loc[K.BC].cutFracClock = grid_.loc[K.BC].cutFracClock;
		this.loc[K.LC].cutFracClock = grid_.loc[K.LC].cutFracClock;
	}

	// ==========================================================================
	public final int firstCornerAcrossBorder(final int startCorner) {
		int currLoc = startCorner;
		boolean hasCrossedCut = false;

		do {
			if (!K.isCorner(currLoc)) {
				hasCrossedCut = this.loc[currLoc].isCut;
			}

			currLoc = K.nextLoc(currLoc); // if was cut want to go to next corner
		} while ((!hasCrossedCut) && (currLoc != startCorner));

		return (currLoc);
	}

	public final int nextActiveCut(final int startLoc) {
		int currLoc = K.nextLoc(startLoc);
		boolean hasFoundCut = false;

		do {
			if (!K.isCorner(currLoc)) {
				hasFoundCut = this.loc[currLoc].isCut;
			}

			if (!hasFoundCut) {
				currLoc = K.nextLoc(currLoc); // if found cut; do not advance
			}
		} while ((!hasFoundCut) && (currLoc != startLoc));

		return (currLoc);
	}

	public final boolean hasVisiblePolyMethod() {
		int currLoc = K.TL;
		boolean hasVisibleCorner = false;

		do {
			if (this.loc[currLoc].status == K.VISIBLE) {
				hasVisibleCorner = true;
			} else {
				currLoc = K.nextLoc(currLoc);
			}
		} while ((!hasVisibleCorner) && (currLoc != K.TL));

		return (hasVisibleCorner);
	}

	public final int firstVisibleCorner() {
		int currLoc = K.TL;
		boolean hasVisibleCorner = false;

		do {
			if (this.loc[currLoc].status == K.VISIBLE) {
				hasVisibleCorner = true;
			} else {
				currLoc = K.nextLoc(currLoc);
			}
		} while ((!hasVisibleCorner) && (currLoc != K.TL));

		return (currLoc);
	}

	// ===== THESE METHODS USED TO SET OUT ======================================
	public final void setCornersByWalkingAndExtending(final TetraC grid_, final int i, final int j,
			final int startCorner) {
		this.setAllLocStatus(K.NOTSET);

		// DO CLOCKWISE TOUR IN WITH TL TERRITORY
		int startLoc = startCorner;
		int currLoc = startLoc;
		boolean hasCrossedCut = false;
		boolean isDone = false;

		do {
			if (K.isCorner(currLoc)) { // currLoc is corner

				if (hasCrossedCut) { // has just crossed cut: set guess and exit
					this.loc[currLoc].setGuessFromExtension(i, j, currLoc, K.prevCorner(currLoc));

					// woutTLstartLoc = currLoc ;
					isDone = true;
				} else { // has not yet crossed cut: set exact from Grid
					this.loc[currLoc].setPointAndStatus(grid_.loc[currLoc], K.EXACT);
				}
			} else { // currLoc is cut location ... not crossed yet
				hasCrossedCut = grid_.loc[currLoc].isCut;
			}

			currLoc = K.nextLoc(currLoc); // go to next location

			if (currLoc == startLoc) {
				isDone = true;
			}
		} while (!isDone);

		// ===== DO COUNTERCLOCKWISE TOUR ======================================
		startLoc = K.prevLoc(startLoc); // no need to repeat setting TL
		currLoc = startLoc;
		hasCrossedCut = false;
		isDone = false;

		do {
			if (K.isCorner(currLoc)) { // currLoc is corner

				if (hasCrossedCut) { // has just crossed cut: set guess and exit
					this.loc[currLoc].setGuessFromExtension(i, j, currLoc, K.nextCorner(currLoc));

					// woutTLstartLoc = currLoc ; // already set above
					isDone = true;
				} else { // has not yet crossed cut: set exact from Grid
					this.loc[currLoc].setPointAndStatus(grid_.loc[currLoc], K.EXACT);
				}
			} else { // currLoc is cut location ... not crossed yet
				hasCrossedCut = grid_.loc[currLoc].isCut;
			}

			currLoc = K.prevLoc(currLoc); // go to next location

			if (currLoc == startLoc) {
				isDone = true;
			}
		} while (!isDone);

		// ===== SET OPPOSITE CORNER IF WITHOUT GUESS
		if (this.loc[K.oppositeLoc(startCorner)].status == K.NOTSET) { // case of cut isolating TL
			this.loc[K.oppositeLoc(startCorner)].x = (this.loc[K.prevCorner(startCorner)].x + this.loc[K
					.nextCorner(startCorner)].x)
					- this.loc[startCorner].x;
			this.loc[K.oppositeLoc(startCorner)].y = (this.loc[K.prevCorner(startCorner)].y + this.loc[K
					.nextCorner(startCorner)].y)
					- this.loc[startCorner].y;
			this.loc[K.oppositeLoc(startCorner)].status = K.GUESS;
		}
	}

	// =========================================================================
	// ===== CALCULATE CUT PROPORTIONS =========================================
	// =========================================================================

	private void setVisibilityToSameAsOut(final TetraC out_, final int cornerLocation) {
		switch (out_.loc[cornerLocation].status) {
		case K.NOTSET:
			this.loc[cornerLocation].status = K.INVISIBLE;

			break;

		case K.EXACT:
			this.loc[cornerLocation].status = K.VISIBLE;

			break;

		case K.GUESS:
			this.loc[cornerLocation].status = K.INVISIBLE;

			break;
		default:
			/* do nothing */
			break;
		}
	}

	private void setVisibilityToNotOut(final TetraC out_, final int cornerLocation) {
		switch (out_.loc[cornerLocation].status) {
		case K.NOTSET:
			this.loc[cornerLocation].status = K.INVISIBLE;

			break;

		case K.EXACT:
			this.loc[cornerLocation].status = K.INVISIBLE;

			break;

		case K.GUESS:
			this.loc[cornerLocation].status = K.VISIBLE;

			break;
		default:
			/* do nothing */
			break;
		}
	}

	public final void calcInFrameOrigCutProportOppCuts(final TetraC out_, final int locCutA, final int locCutC) {
		// sets both polys to false; later activates if one is true
		// hasVisiblePoly = false;
		// hasPolyWoutTL = false;
		// ASSUMES UNDEFORMED GRID... RIGHT ANGLES ... cuts A, B, C, and D
		int locCutB = K.nextCutLoc(locCutA);
		int locCutD = K.nextCutLoc(locCutC);

		float hb = K.cell_HalfBorder;
		float ba = 1.0f - 2.0f * hb;

		float propOutA = out_.loc[locCutA].cutFracClock; // 0..1
		float propOutC = out_.loc[locCutC].cutFracClock; // 0..1

		float propInA = (((hb * (1.0f - propOutA - propOutC)) + propOutA) - hb) / ba; // 0..1
		float propInC = (((hb * (1.0f - propOutA - propOutC)) + propOutC) - hb) / ba; // 0..1

		// false unless made true later
		this.loc[locCutA].isCut = false;
		this.loc[locCutB].isCut = false;
		this.loc[locCutC].isCut = false;
		this.loc[locCutD].isCut = false;

		this.setVisibilityToSameAsOut(out_, K.TL);
		this.setVisibilityToSameAsOut(out_, K.TR);
		this.setVisibilityToSameAsOut(out_, K.BR);
		this.setVisibilityToSameAsOut(out_, K.BL);

		if ((propInA >= 0.0) && (propInA <= 1.0)) {
			// ----- A cut is inside frame
			this.loc[locCutA].isCut = true;
			this.loc[locCutA].cutFracClock = propInA;

			// activatePolyWithStartCorner(startCorner);
			// this.hasVisiblePoly = true;
			if ((propInC >= 0.0) && (propInC <= 1.0)) { // A is in; C is in

				// ----- B cut is inside frame
				this.loc[locCutC].isCut = true;
				this.loc[locCutC].cutFracClock = propInC;

				// Done
			} else if (propInC < 0.0) { // A is in; C is less

				// ----- C cut is to the left of frame: calculate D
				this.loc[locCutB].isCut = true;
				this.loc[locCutB].cutFracClock = (1.0f - propInA) / (1.0f - propInA - propInC);

				this.setVisibilityToNotOut(out_, K.prevCorner(locCutC));
			} else if (propInC > 1.0) { // A is Less, C is more

				// ----- C cut is to the right of frame; claculate C
				this.loc[locCutD].isCut = true;
				this.loc[locCutD].cutFracClock = (1.0f - propInC) / (1.0f - propInA - propInC);

				this.setVisibilityToNotOut(out_, K.nextCorner(locCutC));
			}
		} else if (propInA < 0.0) {
			// academic... no poly activated
			// ----- A cut is to the right of frame
			this.setVisibilityToNotOut(out_, K.prevCorner(locCutA));

			if ((propInC >= 0.0) && (propInC <= 1.0)) { // A is less; C is in
				this.loc[locCutC].isCut = true;
				this.loc[locCutC].cutFracClock = propInC;

				// ----- A cut is to the left of frame: calculate D
				this.loc[locCutD].isCut = true;
				this.loc[locCutD].cutFracClock = (1.0f - propInC) / (1.0f - propInA - propInC);

				// activatePolyWithStartCorner(startCorner);
				// this.hasVisiblePoly = true;
			} else if (propInC < 0.0) { // both less than zero
				this.loc[locCutB].isCut = true;
				this.loc[locCutB].cutFracClock = (1.0f - propInA) / (1.0f - propInA - propInC);

				this.loc[locCutD].isCut = true;
				this.loc[locCutD].cutFracClock = (1.0f - propInC) / (1.0f - propInA - propInC);

				this.setVisibilityToNotOut(out_, K.prevCorner(locCutC));

				// activatePolyWithStartCorner(startCorner);
				// this.hasVisiblePoly = true;
			} else if (propInC > 1.0) { // A is Less, C is more

				// ------ both cuts to the right of frame; no cuts
				// ------ but no activation as well
				this.setVisibilityToNotOut(out_, K.nextCorner(locCutC));
			}
		} else if (propInA > 1.0) {
			// activatePolyWithStartCorner(startCorner);
			this.setVisibilityToNotOut(out_, K.nextCorner(locCutA));

			// ----- A cut is to the right of frame
			if ((propInC >= 0.0) && (propInC <= 1.0)) { // A is more; C is in
				this.loc[locCutC].isCut = true;
				this.loc[locCutC].cutFracClock = propInC;

				this.loc[locCutB].isCut = true;
				this.loc[locCutB].cutFracClock = (1.0f - propInA) / (1.0f - propInA - propInC);

			} else if (propInC < 0.0) { // A is more C is Less

				// both to the right; done
				// note that activated as well
				this.setVisibilityToNotOut(out_, K.prevCorner(locCutC));
			} else if (propInC > 1.0) { // A is more, C is more
				this.loc[locCutB].isCut = true;
				this.loc[locCutB].cutFracClock = (1.0f - propInA) / (1.0f - propInA - propInC);

				this.loc[locCutD].isCut = true;
				this.loc[locCutD].cutFracClock = (1.0f - propInC) / (1.0f - propInA - propInC);

				// this.hasVisiblePoly = true;
				this.setVisibilityToNotOut(out_, K.nextCorner(locCutC));
			}
		}
	}

	public final void calcInFrameOrigCutProportContigCuts(final TetraC out_, final int locCutAprelim,
			final int locCutBprelim) {
		// ASSUMES UNDEFORMED GRID... RIGHT ANGLES ... cuts A, B, C, and D
		// Make sure cut B follows Cut A
		int locCutA;
		int locCutB;
		if (locCutBprelim == K.nextCutLoc(locCutAprelim)) {
			locCutA = locCutAprelim;
			locCutB = locCutBprelim;
		} else {
			locCutA = locCutBprelim;
			locCutB = locCutAprelim;
		}

		int locCutC = K.nextCutLoc(locCutB);
		int locCutD = K.nextCutLoc(locCutC);
		float hb = K.cell_HalfBorder;
		float ba = 1.0f - 2.0f * hb;

		float propOutA = out_.loc[locCutA].cutFracClock; // 0..1
		float propOutB = out_.loc[locCutB].cutFracClock; // 0..1

		float propInA = ((propOutA + ((hb * (1.0f - propOutA)) / propOutB)) - hb) / ba; // 0..1
		float propInB = ((propOutB - ((hb * propOutB) / (1.0f - propOutA))) - hb) / ba; // 0..1

		// false unless made true later
		this.loc[locCutA].isCut = false;
		this.loc[locCutB].isCut = false;
		this.loc[locCutC].isCut = false;
		this.loc[locCutD].isCut = false;

		this.setVisibilityToSameAsOut(out_, K.TL);
		this.setVisibilityToSameAsOut(out_, K.TR);
		this.setVisibilityToSameAsOut(out_, K.BR);
		this.setVisibilityToSameAsOut(out_, K.BL);

		if ((propInA > 1.0) || (propInB < 0.0)) {
			this.setVisibilityToNotOut(out_, K.nextCorner(locCutA));
		}

		if ((propInA >= 0.0) && (propInA <= 1.0) && (propInB >= 0.0) && (propInB <= 1.0)) {
			// ----- A cut is inside frame
			this.loc[locCutA].isCut = true;
			this.loc[locCutA].cutFracClock = propInA;

			// ----- B cut is inside frame
			this.loc[locCutB].isCut = true;
			this.loc[locCutB].cutFracClock = propInB;
		}
	}

	public final void calculCutCoordinates() {
		int currCut = K.TC;
		float mult;

		for (int n = 0; n < 4; n++) {
			if (this.loc[currCut].isCut) {
				int prevCorner = K.prevCorner(currCut);
				int nextCorner = K.nextCorner(currCut);

				mult = this.loc[currCut].cutFracClock;

				this.loc[currCut].x = (mult * this.loc[nextCorner].x) + ((1.0f - mult) * this.loc[prevCorner].x);
				this.loc[currCut].y = (mult * this.loc[nextCorner].y) + ((1.0f - mult) * this.loc[prevCorner].y);
			}

			currCut = K.nextCutLoc(currCut);
		}
	}

	// ===== This method used to shrink quad in order to leave gap between neighbors
	public final void setProportionalReduction(final TetraC outerFrame, final float border) {
		PointC center = new PointC();
		center
				.setAtIntersection(outerFrame.loc[K.TL], outerFrame.loc[K.BR], outerFrame.loc[K.BL],
						outerFrame.loc[K.TR]);

		float proportion = 1.0f - (2.0f * border);
		this.loc[K.TL].setAtProportion(center, outerFrame.loc[K.TL], proportion);
		this.loc[K.TR].setAtProportion(center, outerFrame.loc[K.TR], proportion);
		this.loc[K.BR].setAtProportion(center, outerFrame.loc[K.BR], proportion);
		this.loc[K.BL].setAtProportion(center, outerFrame.loc[K.BL], proportion);
	}

	// =========================================================================
	// -------------------------------------------------------------------------
	// =========================================================================

	public final float manhattanDist(final int locA, final int locB) {

		return (Math.abs(this.loc[locB].x - this.loc[locA].x) + Math.abs(this.loc[locB].y - this.loc[locA].y));
	}

	// =========================================================================
	// -------------------------------------------------------------------------
	// =========================================================================

	static final void dump3TetraIfDebug(final String titleStr, final int i, final int j, final TetraC tetra1,
			final TetraC tetra2, final TetraC tetra3) {

		System.out.println("===================================================");
		System.out.println("***** " + titleStr + " at " + i + ", " + j + " *****");
		System.out.println("---------------------------------------------------");
		System.out.println("------------GRID----OUT-----IN---------------------");
		System.out.println("TL.status" + padStatus(tetra1.loc[0].status) + padStatus(tetra2.loc[0].status)
				+ padStatus(tetra3.loc[0].status));
		System.out.println("TL.x     " + pad(tetra1.loc[0].x) + pad(tetra2.loc[0].x) + pad(tetra3.loc[0].x));
		System.out.println("TL.y     " + pad(tetra1.loc[0].y) + pad(tetra2.loc[0].y) + pad(tetra3.loc[0].y));

		System.out.println("TR.status" + padStatus(tetra1.loc[2].status) + padStatus(tetra2.loc[2].status)
				+ padStatus(tetra3.loc[2].status));
		System.out.println("TR.x     " + pad(tetra1.loc[2].x) + pad(tetra2.loc[2].x) + pad(tetra3.loc[2].x));
		System.out.println("TR.y     " + pad(tetra1.loc[2].y) + pad(tetra2.loc[2].y) + pad(tetra3.loc[2].y));

		System.out.println("BR.status" + padStatus(tetra1.loc[4].status) + padStatus(tetra2.loc[4].status)
				+ padStatus(tetra3.loc[4].status));
		System.out.println("BR.x     " + pad(tetra1.loc[4].x) + pad(tetra2.loc[4].x) + pad(tetra3.loc[4].x));
		System.out.println("BR.y     " + pad(tetra1.loc[4].y) + pad(tetra2.loc[4].y) + pad(tetra3.loc[4].y));

		System.out.println("BL.status" + padStatus(tetra1.loc[6].status) + padStatus(tetra2.loc[4].status)
				+ padStatus(tetra3.loc[6].status));
		System.out.println("BL.x     " + pad(tetra1.loc[6].x) + pad(tetra2.loc[6].x) + pad(tetra3.loc[6].x));
		System.out.println("BL.y     " + pad(tetra1.loc[6].y) + pad(tetra2.loc[6].y) + pad(tetra3.loc[6].y));
		System.out.println("---------------------------------------------------");
		System.out
				.println("TC.isCut " + pad(tetra1.loc[1].isCut) + pad(tetra2.loc[1].isCut) + pad(tetra3.loc[1].isCut));
		System.out.println("TC.cutPos" + pad(tetra1.loc[1].cutFracClock) + pad(tetra2.loc[1].cutFracClock)
				+ pad(tetra3.loc[1].cutFracClock));
		System.out.println("TC.x     " + pad(tetra1.loc[1].x) + pad(tetra2.loc[1].x) + pad(tetra3.loc[1].x));
		System.out.println("TC.y     " + pad(tetra1.loc[1].y) + pad(tetra2.loc[1].y) + pad(tetra3.loc[1].y));
		System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - -");
		System.out
				.println("RC.isCut " + pad(tetra1.loc[3].isCut) + pad(tetra2.loc[3].isCut) + pad(tetra3.loc[3].isCut));
		System.out.println("RC.cutPos" + pad(tetra1.loc[3].cutFracClock) + pad(tetra2.loc[3].cutFracClock)
				+ pad(tetra3.loc[3].cutFracClock));

		System.out.println("RC.x     " + pad(tetra1.loc[3].x) + pad(tetra2.loc[3].x) + pad(tetra3.loc[3].x));
		System.out.println("RC.y     " + pad(tetra1.loc[3].y) + pad(tetra2.loc[3].y) + pad(tetra3.loc[3].y));
		System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - -");
		System.out
				.println("BC.isCut " + pad(tetra1.loc[5].isCut) + pad(tetra2.loc[5].isCut) + pad(tetra3.loc[5].isCut));
		System.out.println("BC.cutPos" + pad(tetra1.loc[5].cutFracClock) + pad(tetra2.loc[5].cutFracClock)
				+ pad(tetra3.loc[5].cutFracClock));
		System.out.println("BC.x     " + pad(tetra1.loc[5].x) + pad(tetra2.loc[5].x) + pad(tetra3.loc[5].x));
		System.out.println("BC.y     " + pad(tetra1.loc[5].y) + pad(tetra2.loc[5].y) + pad(tetra3.loc[5].y));
		System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - -");
		System.out
				.println("LC.isCut " + pad(tetra1.loc[7].isCut) + pad(tetra2.loc[7].isCut) + pad(tetra3.loc[7].isCut));
		System.out.println("LC.cutPos" + pad(tetra1.loc[7].cutFracClock) + pad(tetra2.loc[7].cutFracClock)
				+ pad(tetra3.loc[7].cutFracClock));
		System.out.println("LC.x     " + pad(tetra1.loc[7].x) + pad(tetra2.loc[7].x) + pad(tetra3.loc[7].x));
		System.out.println("LC.y     " + pad(tetra1.loc[7].y) + pad(tetra2.loc[7].y) + pad(tetra3.loc[7].y));
		System.out.println("---------------------------------------------------");
		System.out.println("nCuts    " + pad(tetra1.nCutsOut) + pad(tetra2.nCutsOut) + pad(tetra3.nCutsOut));
		System.out
				.println("shapeCode" + pad(tetra1.shapeCodeOut) + pad(tetra2.shapeCodeOut) + pad(tetra3.shapeCodeOut));
		System.out.println("---------------------------------------------------");

	}

	private static String pad(final int n) {
		return ("    " + myInt.format(n));
	}

	private static String pad(final boolean b) {
		if (b) {
			return ("   true ");
		}
		return ("   false");
	}

	private static String padStatus(final int status) {
		switch (status) {
		case 0:
			return " not_set";
		case 1:
			return "  guess ";
		case 2:
			return "  exact ";
		default:
			return "  ERROR ";
		}
	}

	private static String pad(final float d) {
		return ("  " + myDouble3.format(d));
	}

}
