/* this class interpets the mouse gestures
 * it also choreographs the sequence of events
 * triggered by mouse gestures, passing time, and size of the deformed grid */

public class States {

	// SHARED VARS ARE KEPT IN CLASS K
	private static final boolean isPrintActionsAndStateChangesDEBUG = false;
	// ------------------------------------------------------------------------
	private static final int RESETGRID = 0;
	private static final int WAITING = 1; // do not use WAIT ... java reserved word
	private static final int RIPSTARTED = 2;
	private static final int RIPENDED = 3;
	private static final int OPENINGRIP = 4;
	private static final int DEFORMING = 5;
	private static final int INFLATING = 6;
	private static final int DEFLATING = 7;
	private static final int CLOSING = 8;
	private static final int RECOVERING = 9;
	private static final int SHIMMERING1 = 10;
	private static final int SHIMMERING2 = 11;

	private static final int[] nextSTATE = { WAITING, WAITING, RIPENDED, OPENINGRIP, DEFORMING, INFLATING, DEFLATING,
			CLOSING, RECOVERING, WAITING, RECOVERING, RECOVERING };

	private static final String[] nameSTATE = { "[0] RESET GRID", "[1] WAITING", "[2] RIP STARTED", "[3] RIP ENDED",
			"[4] OPENING RIP", "[5] DEFORMING", "[6] INFLATING", "[7] DEFLATING", "[8] CLOSING", "[9] RECOVERING",
			"[10] SHIMMERING1", "[10] SHIMMERING2" };

	private static int oldState = RESETGRID;
	private static int state = RESETGRID;
	// ------------------------------------ RESET WAIT RIPS RIPEND OPENIN DEFORM INFLAT DEFL CLOSIN RECOV SHIMM1 SHIMM2
	private static float[] sMaxGridSize = { 2.0f, 9.9f, 2.0f, 2.0f, 2.0f, 0.91f, 2.0f, 0.89f, 2.0f, 9, 9f, 2.0f, 2.0f };
	private static float[] sMinGridSize = { 0.5f, 0.0f, 0.5f, 0.5f, 0.5f, 0.89f, 0.1f, 0.0f, 0.5f, 0.0f, 0.5f, 0.5f };

	private static float[] sSpringAtRest = { 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.4f, 0.6f };
	private static float[] sElasticConst = { 0.2f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.2f, 0.4f };
	private static float[] sBendg2Elastic = { 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f };
	private static float[] sTxtContrast0to1 = { 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f };
	private static float[] sStrokeContrast = { 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f };
	private static float[] sCell_HalfBorder = { 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.1f, 0.1f, 0.0f, 0.0f, 0.0f, 0.0f };
	private static boolean[] sIsCalcThisCycle = { true, true, false, false, true, true, true, true, true, true, true,
			true };
	private static boolean[] sIsCutAllowed = { true, true, true, true, false, false, false, false, true, true, true,
			true };
	// ------------------------------------- RESET WAIT RIP REND OPEN DEF0 INFL DEFL CLOS RECOV SHIM1 SHIM2
	private static int[] sMaxIterPerState = { 50, 1200, 400, 400, 50, 400, 400, 400, 100, 100, 100, 200 };
	// ----------------------------------------------------
	private static final int maxItersWithoutAction = 1200;
	private static int itersSinceLastActionOrRecoveryState = 0;

	private static final int itersTRANSITION = 40;
	private static int itersInState;

	private static boolean isOneTimeAutomaticMendingEnabled = true;

	// -----control status---------------------------------
	private static float textContrastFactor = 1.0f;
	private static float strokContrast0to1 = 0.0f;
	private static boolean isCalcThisCycle;
	// ====================================================
	private static final int _UnitializedACTION = 0;
	private static final int _NoACTION = 1;
	private static final int _PossibleSingleClickACTION = 2;
	private static final int _SClickShim1ACTION = 3;
	private static final int _SClickShim2ACTION = 4;
	private static final int _DClickMendsACTION = 5;
	private static final int _DClickResetACTION = 6;
	private static final int _LineOutsideACTION = 7;
	private static final int _LineTooShortACTION = 8;
	private static final int _LineInsideACTION = 9;
	private static final int _ClickThenDrawACTION = 10;
	private static final int _MessagesOnACTION = 11;
	private static final int _MessagesOffACTION = 12;
	private static final int _HaveFunACTION = 13;

	private static final String[] nameACTION = { "Unitiliazed action", "No action", "Possible S_Click",
			"S_Click Shimm1", "S_Click Shimm2", "D_Click Mends", "D_Click Resets", "Line Out", "Line short",
			"Line inside", "Click & Draw", "Messages ON", "Messages OFF", "Have Fun" };

	// ------------------------------------- unin no po s1 s2 dm dr lou lsh lin cd mOn mOff haveFun
	private static int[] messagesLeftToGive = { 1, 1, 1, 1, 1, 2, 1, 99, 99, 1, 1, 99, 99, 1 };

	private static int action = _NoACTION;
	private static int feedback = _NoACTION;

	private static boolean isActionWaitingToBeProcessed = false;
	private static boolean isActionFeedbackWaitingToBeShown = false;
	private static boolean isActionSinceLastInstructMessage = true;
	private static boolean isFeedbackMessageShowingRightNow = false;
	private static boolean isInstructionalMessageShowingRightNow = false;

	private static boolean isNewStateWaitingToBeInitialized = true;

	private static final long millisForDoubleClick = 450;
	private static final long millisToConfirmSingleClick = 500;
	private static long lastClockOnPointRelease;
	// ----------------------------------------------------

	private static final int[] instructMessages = { _UnitializedACTION, _NoACTION, _SClickShim1ACTION,
			_DClickMendsACTION, _HaveFunACTION };

	private static final int instructMessageIxMAX = 4;
	private static int instructMessageIx = _UnitializedACTION;

	private static int messagesOff0_limited1_on2 = 1;

	private static int txtItersMAX = 60;
	private static final int txtItersRAMP = 10;
	private static final int minItersBetweenInstructlMessages = 10;
	private static int itersSinceLastTxtFadeUpdate = minItersBetweenInstructlMessages + 1; // for immediate
	private static int txtIters;

	//----- have two text buffers in case want to cross-fade text in future
	private static int oldBuff = 0;
	private static int newBuff = 1;
	private static float textFadeBuff0;
	private static float textFadeBuff1;

	// ------------------------------------------------------------------------
	private static boolean isGridRipped = false;

	// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
	private States() {
		/* empty */
	}

	// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	static final boolean getIsWaitingState() {
		return (state == WAITING);
	}

	static final boolean getIsCurrentStateTryNotToErase() {
		return ((state == OPENINGRIP) || (state == DEFORMING));
	}

	static boolean getIsCalcThisCycle() {
		return isCalcThisCycle;
	}

	static float getStrokeContrast() {
		return strokContrast0to1;
	}

	static void printFrameCountIfDebug(final float fps) {
		if (isPrintActionsAndStateChangesDEBUG) {
			System.out.println("..... " + nameSTATE[state] + " FPS: " + K.doubleToDouble3(fps));
		}
	}

	// XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	static final void init() {
		setNewState(RESETGRID);
		showNoMessage(true); // clears buffer for fade out
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	// ========================================================================
	// ----- called by Mouse Released
	// ========================================================================
	// -----note that interpret gestures does not wait for draw cycle
	static final void interpretAllGesturesIntoActions() { // called whenever mouse released

		if (RIP.wasMouseDragged()) { // line:

			Map.interpretLineGesturesAndStoreRipCoords();
			// ----- the Map method calls the method below

		} else { // point: either click or doubleCLick

			long now = System.currentTimeMillis();
			if ((now - lastClockOnPointRelease) < millisForDoubleClick) {

				if (isGridRipped) {
					setAction(_DClickMendsACTION);
				} else {
					setAction(_DClickResetACTION);
				}
			} else {
				setAction(_PossibleSingleClickACTION); // to be confirmed in a few ms
			}
			lastClockOnPointRelease = now;
		}
	}

	// ----- this is called by the Map method, called by the method above
	static final void interpretLineGesturesIntoActions(final boolean isRipOnCanvas, final float manhDist) {

		if (isRipOnCanvas) {

			if (manhDist > 2.0) {

				setAction(_LineInsideACTION);

			} else if (manhDist > 0.2) {
				setAction(_LineTooShortACTION);
			} else {
				if ((System.currentTimeMillis() - lastClockOnPointRelease) > millisToConfirmSingleClick) {
					if (state == SHIMMERING1) {
						setAction(_SClickShim2ACTION);
					} else {
						setAction(_SClickShim1ACTION);
					}
				}
			}
		} else {
			setAction(_LineOutsideACTION);
		}
	}

	// revisited each cycle
	static final void confirmSingleClickIfEnoughTimeHasPassed() {
		if (action == _PossibleSingleClickACTION) {
			if ((System.currentTimeMillis() - lastClockOnPointRelease) > millisToConfirmSingleClick) {
				if (state == SHIMMERING1) {
					setAction(_SClickShim2ACTION);
				} else {
					setAction(_SClickShim1ACTION);
				}
			}
		}
	}

	static final void setAutomaticClosingAction() {

		setAction(_DClickMendsACTION);
		isOneTimeAutomaticMendingEnabled = false;
	}

	// called by WAITING
	static final void setActionForWaitingTooLong() {
		if (isGridRipped) {
			setAction(_DClickMendsACTION); // for automatic closes
		} else {
			setAction(_SClickShim1ACTION); // for automatic shimmers
		}
	}

	// called by RIP
	static final void toggleMessagesOnOff() {

		if (messagesOff0_limited1_on2 > 0) {
			// messagesOff0_limited1_on2 = 0; set below
			setAction(_MessagesOffACTION);
		} else {
			// messagesOff0_limited1_on2 = 2; set below
			setAction(_MessagesOnACTION);
		}
	}

	// ////////////////////////////////////////////////////////////////////////
	// SET ACTIONS SET ACTIONS SET ACTIONS SET ACTIONS SET ACTIONS
	// ////////////////////////////////////////////////////////////////////////

	private static void setAction(final int action_) {

		action = action_;
		feedback = action_;
		isActionWaitingToBeProcessed = true;
		isActionFeedbackWaitingToBeShown = true;
		isActionSinceLastInstructMessage = true;
		itersSinceLastActionOrRecoveryState = 0;

		if (isPrintActionsAndStateChangesDEBUG) {
			System.out.println("===== Action: " + nameACTION[action]);
		}
	}

	// ////////////////////////////////////////////////////////////////////////
	// TURN ACTIONS INTO STATES TURN ACTIONS INTO STATES
	// ////////////////////////////////////////////////////////////////////////

	static final void turnActionsIntoStates() {

		switch (action) {

		case _UnitializedACTION:
			setNewState(RESETGRID);
			break;
		case _NoACTION:
		case _PossibleSingleClickACTION:
			/* do nothing */
			break;
		case _SClickShim1ACTION:
			setNewState(SHIMMERING1);
			break;
		case _SClickShim2ACTION:
			setNewState(SHIMMERING2);
			break;
		case _DClickMendsACTION:
			setNewState(CLOSING);
			break;
		case _DClickResetACTION:
			setNewState(RESETGRID);
			break;
		case _LineOutsideACTION:
		case _LineTooShortACTION:
			setNewState(WAITING);
			break;
		case _LineInsideACTION:
			if (sIsCutAllowed[state]) {
				setNewState(OPENINGRIP);
			}
			break;
		case _ClickThenDrawACTION:
			/* do nothing */
			break;
		case _MessagesOnACTION:
			messagesOff0_limited1_on2 = 2;
			break;
		case _MessagesOffACTION:
			messagesOff0_limited1_on2 = 0;
			break;
		case _HaveFunACTION:
		default:
			/* do nothing */
			break;
		}
	}

	private static void manageRipStartAndRipEnd() {

		if (RIP.getIsMousePressed()) {
			if (state == WAITING) {
				setNewState(RIPSTARTED);
			}
		} else { // mouse not pressed
			if (state == RIPSTARTED) {
				setNewState(RIPENDED);
			}
		}
	}

	// ////////////////////////////////////////////////////////////////////////
	// SET STATE SET STATE SET STATE SET STATE SET STATE
	// ////////////////////////////////////////////////////////////////////////

	private static void setNewState(final int newState_) {

		if (newState_ >= SHIMMERING1) {
			oldState = newState_; // for immediate transition into state
		} else {
			oldState = state;
		}
		state = newState_;
		isNewStateWaitingToBeInitialized = true;

		if (isPrintActionsAndStateChangesDEBUG) {
			System.out.println("----- " + nameSTATE[oldState] + " ===> " + nameSTATE[state]);
		}
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	// ========================================================================
	// ----- called by Draw
	// ========================================================================
	static final void convertTimeGridSizeAndActionsToNewStates() {

		// --------------------------------------------------------------------
		// -----check for time triggers ... overrriden by grid size and gestures
		// --------------------------------------------------------------------
		itersInState++;
		boolean isExceeded = (itersInState >= sMaxIterPerState[state]);
		if (isExceeded) {
			if (state == WAITING) {

				if (itersSinceLastActionOrRecoveryState >= maxItersWithoutAction) {

					setActionForWaitingTooLong();

				} else {
					setNewState(WAITING);
				}
			} else if ((state == RESETGRID) || (state >= OPENINGRIP)) {
				setNewState(nextSTATE[state]);
			} // other states do not have a time limit
		}

		// ----- automatic closing if not closed before
		if (isGridRipped && (state == WAITING) && isOneTimeAutomaticMendingEnabled) {
			setAutomaticClosingAction();
		}

		// --------------------------------------------------------------------
		// -----check for grid size triggers ... overriden by gestures
		// --------------------------------------------------------------------

		if ((Map.getGridSize0to1() < sMinGridSize[state]) || (Map.getGridSize0to1() > sMaxGridSize[state])) {

			setNewState(nextSTATE[state]);
		}

		// --------------------------------------------------------------------
		// ----- turn actions into States
		// --------------------------------------------------------------------
		itersSinceLastActionOrRecoveryState++;

		confirmSingleClickIfEnoughTimeHasPassed();

		if (isActionWaitingToBeProcessed) {
			turnActionsIntoStates();
			isActionWaitingToBeProcessed = false;
		} else {
			manageRipStartAndRipEnd();
		}

		// --------------------------------------------------------------------
		// -----manage state transitions ... what happens at the beginning of the new state
		// --------------------------------------------------------------------
		if (isNewStateWaitingToBeInitialized) {

			itersInState = 0;
			isCalcThisCycle = sIsCalcThisCycle[state];

			switch (state) {
			case RESETGRID:
				Calc.resetGridXY();
				Calc.mendRips();
				isGridRipped = false;
				break;
			case WAITING:
				/* do nothing */
				break;
			case RIPSTARTED:
				if (isGridRipped) {
					Calc.mendRips(); // duplicated but here if Closing is shortcut
					isGridRipped = false;
				}
				break;
			case RIPENDED: // transition state by definition
				/* do nothing */
				break;
			case OPENINGRIP:
				Map.implementRip(); // only place where this action happens
				isGridRipped = true;
				break;
			case DEFORMING:
			case INFLATING:
			case DEFLATING:
				/* do nothing */
				break;
			case CLOSING:
				if (isGridRipped) {
					Calc.mendRips();
					isGridRipped = false;
				}
				break;
			case RECOVERING:
				itersSinceLastActionOrRecoveryState = 0; // to reset counter
				break;
			case SHIMMERING1:
				sSpringAtRest[SHIMMERING1] = 1.4f + 0.6f * (float) Math.random();
				Map.disturbGridIfNeeded();
				break;
			case SHIMMERING2:
				sSpringAtRest[SHIMMERING2] = 0.5f + 0.2f * (float) Math.random();
				Map.disturbGridIfNeeded();
				break;
			default:
				/* do nothing */
				break;
			}
			isNewStateWaitingToBeInitialized = false;
		}

		// --------------------------------------------------------------------
		// fade in new calculation and display constants
		// ---------------------------------------------------------------------
		if (itersInState <= itersTRANSITION) {

			float alpha = (float) itersInState / itersTRANSITION; // 0 to 1

			K.springSizAtRest = alpha * sSpringAtRest[state] + (1 - alpha) * sSpringAtRest[oldState];
			K.elasticConstant = alpha * sElasticConst[state] + (1 - alpha) * sElasticConst[oldState];
			K.bending2Elastic = alpha * sBendg2Elastic[state] + (1 - alpha) * sBendg2Elastic[oldState];

			K.cell_HalfBorder = alpha * sCell_HalfBorder[state] + (1 - alpha) * sCell_HalfBorder[oldState];

			textContrastFactor = alpha * sTxtContrast0to1[state] + (1 - alpha) * sTxtContrast0to1[oldState];
			strokContrast0to1 = alpha * sStrokeContrast[state] + (1 - alpha) * sStrokeContrast[oldState];
		}

		// --------------------------------------------------------------------
		// manage messages
		// --------------------------------------------------------------------
		manageMessages();
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	private static void manageMessages() {

		if ((state == RESETGRID) || (state == WAITING) || (state == RECOVERING)) {

			if ((messagesOff0_limited1_on2 > 0) || (feedback == _MessagesOffACTION)) { // not off
				// ----- trigger new feedback messages
				if (isActionFeedbackWaitingToBeShown
						&& ((messagesOff0_limited1_on2 == 2)
								|| ((messagesOff0_limited1_on2 == 1) && (messagesLeftToGive[feedback] > 0)) || (feedback == _MessagesOffACTION))) {
					showActionFeedbackMessage();
					messagesLeftToGive[feedback] -= 1; // record that action was tried ... OK to go negative if
					// messagesON
					isActionFeedbackWaitingToBeShown = false;
					isFeedbackMessageShowingRightNow = true;
					txtIters = 0;

					// ----- trigger new instructional messages
				} else if ((state == RESETGRID) || (state == WAITING)) { // do not start instructions in RECOVERING

					if ((!isFeedbackMessageShowingRightNow) && (!isInstructionalMessageShowingRightNow)
							&& (instructMessageIx <= instructMessageIxMAX) && isActionSinceLastInstructMessage) { // waits
						// for
						// some
						// action

						if (itersSinceLastTxtFadeUpdate > minItersBetweenInstructlMessages) {

							// skip messages relating to actions already tried
							while ((instructMessageIx < instructMessageIxMAX)
									&& (messagesLeftToGive[instructMessages[instructMessageIx]] < 1)) {
								instructMessageIx++;
							}
							showInstructionalMessage(instructMessages[instructMessageIx]);
							if (instructMessages[instructMessageIx] != _UnitializedACTION) {
								isActionSinceLastInstructMessage = false;
							}
							messagesLeftToGive[instructMessages[instructMessageIx]] -= 1; // record that action was
							// tried ... OK to go
							// negative if messagesON
							isInstructionalMessageShowingRightNow = true;
							txtIters = 0;
						}
					}
				}
			}
		}

		itersSinceLastTxtFadeUpdate++; // incremented every cycle
		// only increments txtIters when can show text
		if (textContrastFactor > 0.001f) {
			if (txtIters >= txtItersMAX) {

				if (isInstructionalMessageShowingRightNow) {
					instructMessageIx++; // increments messages shown when completes showing them
				}
				isFeedbackMessageShowingRightNow = false;
				isInstructionalMessageShowingRightNow = false;

			} else { // txtIters < txtItersMAX

				float textFadeOldBuff = 0.0f;
				float textFadeNewBuff = 1.0f;

				itersSinceLastTxtFadeUpdate = 0;
				txtIters++;

				if (txtIters <= txtItersRAMP) { // FADE IN ... uses max, min

					textFadeNewBuff = (float) txtIters / txtItersRAMP;
					textFadeOldBuff = 1.0f - textFadeNewBuff;

					if (newBuff == 1) {

						textFadeBuff0 = Math.min(textFadeBuff0, textFadeOldBuff);
						textFadeBuff1 = Math.max(textFadeBuff1, textFadeNewBuff);

					} else {

						textFadeBuff0 = Math.max(textFadeBuff0, textFadeNewBuff);
						textFadeBuff1 = Math.min(textFadeBuff1, textFadeOldBuff);
					}

				} else { // FADE IN COMPLETE

					if (txtIters >= (txtItersMAX - txtItersRAMP)) {

						textFadeNewBuff = (float) (txtItersMAX - txtIters) / txtItersRAMP;
						// textFadeOldBuff already down to zero
					}

					if (newBuff == 1) {

						textFadeBuff0 = textFadeOldBuff;
						textFadeBuff1 = textFadeNewBuff;

					} else {

						textFadeBuff0 = textFadeNewBuff;
						textFadeBuff1 = textFadeOldBuff;
					}
				}
			}
		}
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	static float getContrastForCellIJ(final int i_, final int j_) {

		float maxTextContrast = 0.0f;

		// same condition used for updating Fade values
		if ((textContrastFactor > 0.001f) && (txtIters <= txtItersMAX)) {

			if (Txt.txtGrid[0][i_][j_]) {
				maxTextContrast = textFadeBuff0;
			}
			if (Txt.txtGrid[1][i_][j_]) {
				maxTextContrast = Math.max(maxTextContrast, textFadeBuff1);
			}
		}
		return maxTextContrast;
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	private static void switchBuffers(final boolean isImmediate, final int iters) {

		oldBuff = 1 - oldBuff;
		newBuff = 1 - oldBuff;
		if (isImmediate) {
			textFadeBuff0 = oldBuff;
			textFadeBuff1 = newBuff;
		}
		Txt.clearTextGrid(newBuff);
		txtItersMAX = iters;
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	private static void showInstructionalMessage(final int message) {

		switch (message) {

		case _UnitializedACTION:
			showMessage(false, 30, "hello");
			isActionSinceLastInstructMessage = true;
			break;

		case _NoACTION:
			showMessage(false, 200, "draw", "a line,", "release,", "sit back,", "watch");
			break;

		case _PossibleSingleClickACTION:
			showMessage(false, 100, "draw", "a", "line", "then", "watch");
			break;

		case _SClickShim1ACTION:
			showMessage(false, 80, "to tickle:", "", "one", "click");
			break;

		case _SClickShim2ACTION:
			showMessage(false, 80, "to tickle", "more:", "", "another", "click");
			break;

		case _DClickMendsACTION:
			showMessage(false, 80, "to mend", "rips:", "", "double", "click");
			break;

		case _DClickResetACTION:
			showMessage(false, 80, "to reset:", "", "double", "click", "twice");
			break;

		case _LineOutsideACTION:
			showMessage(false, 80, "try also:", "", "line,", "click,", "line");
			break;

		case _LineTooShortACTION:
			showMessage(false, 80, "again:", "double", "clicking", "mends,", "rips");
			break;

		case _LineInsideACTION:
			showMessage(false, 60, "to draw:", "", "click,", "drag,", "release");
			break;

		case _ClickThenDrawACTION:
			showMessage(false, 80, "try also:", "", "click", "then", "line");
			break;

		case _MessagesOnACTION:
			showMessage(false, 80, "resume", "messages", "by", "pressing", "spacebar");
			break;
		case _MessagesOffACTION:
			showMessage(false, 80, "to stop", "messages", "press", "the", "spacebar");
			break;
		case _HaveFunACTION:
			showMessage(false, 80, "have", "fun!");
			break;
		default:
			/* do nothing */
			break;
		}
	}

	private static void showActionFeedbackMessage() {

		switch (feedback) {

		case _UnitializedACTION:
			showMessage(false, 100, "hello");
			break;

		case _NoACTION:
			showMessage(true, 100, "draw", "a", "line", "then", "watch");
			break;

		case _PossibleSingleClickACTION:
			/* do nothing */
			break;

		case _SClickShim1ACTION:
			showMessage(false, 100, "one", "click", "tickles");
			break;

		case _SClickShim2ACTION:
			showMessage(false, 100, "a second", "click", "tickles", "more");
			break;

		case _DClickMendsACTION:
			showMessage(false, 100, "double", "clicking", "once", "mends", "rips");
			break;

		case _DClickResetACTION:
			showMessage(false, 100, "double", "clicking", "twice", "resets");
			break;

		case _LineOutsideACTION:
			showMessage(true, 80, "draw", "inside", "canvas!");
			break;

		case _LineTooShortACTION:
			showMessage(true, 80, "line", "is too", "short!");
			break;

		case _LineInsideACTION:
			showMessage(false, 100, "line", "cuts", "canvas");
			break;

		case _ClickThenDrawACTION:
			showMessage(true, 100, "draw", "a", "line", "then", "watch");
			break;

		case _MessagesOnACTION:
			showMessage(true, 80, "messages", "on");
			break;
		case _MessagesOffACTION:
			showMessage(true, 80, "messages", "off");
			break;
		case _HaveFunACTION:
			showMessage(false, 100, "have", "fun!");
			break;
		default:
			/* do nothing */
			break;
		}
	}

	private static void showNoMessage(final boolean isImmediate) {
		switchBuffers(isImmediate, 60);
		Txt.clearTextGrid(newBuff);
	}

	private static void showMessage(final boolean isImmediate, final int iters, final String str1) {
		switchBuffers(isImmediate, iters);
		Txt.writeLine1to5(newBuff, 1, 1, str1);
	}

	private static void showMessage(final boolean isImmediate, final int iters, final String str1, final String str2) {
		switchBuffers(isImmediate, iters);
		Txt.writeLine1to5(newBuff, 1, 2, str1);
		Txt.writeLine1to5(newBuff, 2, 2, str2);
	}

	private static void showMessage(final boolean isImmediate, final int iters, final String str1, final String str2,
			final String str3) {
		switchBuffers(isImmediate, iters);
		Txt.writeLine1to5(newBuff, 1, 3, str1);
		Txt.writeLine1to5(newBuff, 2, 3, str2);
		Txt.writeLine1to5(newBuff, 3, 3, str3);
	}

	private static void showMessage(final boolean isImmediate, final int iters, final String str1, final String str2,
			final String str3, final String str4) {
		switchBuffers(isImmediate, iters);
		Txt.writeLine1to5(newBuff, 1, 4, str1);
		Txt.writeLine1to5(newBuff, 2, 4, str2);
		Txt.writeLine1to5(newBuff, 3, 4, str3);
		Txt.writeLine1to5(newBuff, 4, 4, str4);
	}

	private static void showMessage(final boolean isImmediate, final int iters, final String str1, final String str2,
			final String str3, final String str4, final String str5) {
		switchBuffers(isImmediate, iters);
		Txt.writeLine1to5(newBuff, 1, 5, str1);
		Txt.writeLine1to5(newBuff, 2, 5, str2);
		Txt.writeLine1to5(newBuff, 3, 5, str3);
		Txt.writeLine1to5(newBuff, 4, 5, str4);
		Txt.writeLine1to5(newBuff, 5, 5, str5);
	}
}
