import java.awt.Color;

import processing.core.*;

/* This main class does the drawing and uses the processing.core library extensively
 *
 * Processing is an open project initiated by Ben Fry and Casey Reas
 * http://processing.org/
 */


public class RIP extends PApplet {

	static int ripX0; // expressed in Pixels
	static int ripY0;
	static int ripY1;
	static int ripX1;

	// ----------------------------------------------------
	private static final boolean isShownInBrowser = true;

	// -----control status: mouse in canvas
	private static boolean isMousePressed = false;

	// -----control status---------------------------------
	private boolean isRestart = false;
	private boolean isLineShowing = false;

	// ----------------------------------------------------
	private static int backgroundColor0to255 = 0;

	// ========================================================================
	private static TetraC grid = new TetraC();
	private static TetraC outQuad = new TetraC(); // the perimeter of the cell
	private static TetraC inQuad = new TetraC(); // inside, allowing for border

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	static boolean getIsMousePressed() {
		return isMousePressed;
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////




	@Override
	public final void setup() {

		Map.setCanvasSizePix(isShownInBrowser, this.screen.width, this.screen.height);
		size(Map.getCanvasSizePix(), Map.getCanvasSizePix()); // , P3D);

		Calc.init();
		States.init();
		Map.resetPandAndZoom();
		background(backgroundColor0to255);
		noSmooth();
		autoPanAndPaint();
	}

	@Override
	public final void draw() {

		States.convertTimeGridSizeAndActionsToNewStates();

		// -----perform calculations on grid

		if (this.isRestart) {
			Calc.resetGridXY();
			Map.resetPandAndZoom();
			background(backgroundColor0to255);
			this.isRestart = false;
		}

		if( States.getIsCalcThisCycle()) {
			Calc.deformGrid(true);
		}

		// -----draw to screen
		autoPanAndPaint();

		// -----report timing
		if ((this.frameCount % 100) == 0) {
			States.printFrameCountIfDebug(this.frameRate);
		}
	}

	void drawLine(final int x0, final int y0, final int x1, final int y1) {
		line(x0, y0, x1, y1);
	}

	private void autoPanAndPaint() {

		Map.autoPanAndZoom();

		if (this.isLineShowing || !States.getIsCurrentStateTryNotToErase()) {
			background(backgroundColor0to255);
			this.isLineShowing = false;
		}

		paintQuads();

		// -----check if ripping
		if (isMousePressed) {

			drawSegmentedLine(ripX0, ripY0, this.mouseX, this.mouseY);
			strokeWeight(1);
		}
	}

	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

	@Override
	public final void mousePressed() {

		if (!isMousePressed) {
			ripX0 = this.mouseX;
			ripY0 = this.mouseY;
			isMousePressed = true;
		}
	}

	@Override
	public final void mouseReleased() {

		if (isMousePressed) {
			ripX1 = this.mouseX;
			ripY1 = this.mouseY;

			States.interpretAllGesturesIntoActions();
			isMousePressed = false;
		}
	}

	static boolean wasMouseDragged() {
		return ((ripX0 != ripX1) || (ripY0 != ripY1));
	}

	@Override
	public final void keyReleased() {


		if (this.key == ' ') {
			States.toggleMessagesOnOff();
		}
	}

	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
	// \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

	public final void paintQuads() {

		for (int i = 0; i < K.gridSize; i++) {
			for (int j = 0; j < K.gridSize; j++) {

				grid.clear();
				outQuad.clear();
				grid.copyIsCutCutPosAndXYFromGridNodes(i, j); // also sets shapeCode and nCuts

				updateAllColors(i, j, 0.72f, 1.0f, true);

				switch (grid.nCutsOut) {
				case 0: // no cuts
				case 1: // one cut
					inQuad.setProportionalReduction(grid, K.cell_HalfBorder);
					drawQuad(inQuad);
					break;

				case 2: // two cuts
					// copy isCut and cut proportions (but not cut locations)
					outQuad.copyNCutsShapeCodeAndIsCutSettingsFromTetra(grid);

					int startCorner = K.TL;

					paintSingleSideOfTetraWith2Cuts(i, j, K.TL);
					// --------------------------------------------------------------
					startCorner = grid.firstCornerAcrossBorder(K.TL);

					if (startCorner != K.TL) { // more than one region (always, if two cuts!)

						paintSingleSideOfTetraWith2Cuts(i, j, startCorner);
					}
					break;

				case 3: // three cuts
				case 4: // four cuts
				default:
					// do nothing
					break;
				}
			}
		}
	}

	final void paintSingleSideOfTetraWith2Cuts(final int i, final int j, final int startCorner) {

		outQuad.clearLocationCoords(); // useful only in debugging since set by paint
		inQuad.clear();

		// -----calculate Corner coordinates-----------------------------------
		outQuad.setCornersByWalkingAndExtending(grid, i, j, startCorner);

		// -----calculate cuts-------------------------------------------------
		int outFstCut = outQuad.nextActiveCut(startCorner);
		int outSecCut = outQuad.nextActiveCut(outFstCut);

		if (outSecCut == K.oppositeLoc(outFstCut)) {
			inQuad.calcInFrameOrigCutProportOppCuts(outQuad, outFstCut, outSecCut);
		} else {
			inQuad.calcInFrameOrigCutProportContigCuts(outQuad, outFstCut, outSecCut);
		}

		// -----calculate inQuad by reducing outQuad
		inQuad.setProportionalReduction(outQuad, K.cell_HalfBorder);
		inQuad.calculCutCoordinates();
		drawPolyIfVisible(inQuad);
	}

	public final void drawPolyIfVisible(final TetraC tetra) {

		if (tetra.hasVisiblePolyMethod()) {

			beginShape();

			int startLoc = tetra.firstVisibleCorner();
			int currLoc = startLoc;
			boolean hasReachedCut = !K.isCorner(currLoc);
			vertex(Map.getXpix(tetra.loc[currLoc].x), Map.getYpix(tetra.loc[currLoc].y));

			do {
				if (K.isCorner(currLoc)) { // currLoc is corner

					if (tetra.loc[K.nextCutLoc(currLoc)].isCut) {

						currLoc = K.nextCutLoc(currLoc); // now current location is cut

						hasReachedCut = true;

					} else { // not cut ... proceed to next corner
						currLoc = K.nextCorner(currLoc);
					}
				} else { // currLoc is cut location

					if (hasReachedCut) { //

						do {
							currLoc = K.nextCutLoc(currLoc);
						} while (!tetra.loc[currLoc].isCut);

						hasReachedCut = false;
					} else { // has not yet crossed cut: set exact from Grid
						currLoc = K.nextCorner(currLoc);
					}
				}
				vertex(Map.getXpix(tetra.loc[currLoc].x), Map.getYpix(tetra.loc[currLoc].y));

			} while (currLoc != startLoc);

			endShape();
		}
	}

	private void drawQuad(final TetraC tetra) {

		quad(Map.getXpix(tetra.loc[K.TL].x), Map.getYpix(tetra.loc[K.TL].y), Map.getXpix(tetra.loc[K.TR].x), Map
				.getYpix(tetra.loc[K.TR].y), Map.getXpix(tetra.loc[K.BR].x), Map.getYpix(tetra.loc[K.BR].y), Map
				.getXpix(tetra.loc[K.BL].x), Map.getYpix(tetra.loc[K.BL].y));
	}

	void drawSegmentedLine(final int x0pix, final int y0pix, final int x1pix, final int y1pix) {

		Map.updateIFloatAndJFloatFromXYpix(x0pix, y0pix);
		float i0Line = Map.iFloat;
		float j0Line = Map.jFloat;

		Map.updateIFloatAndJFloatFromXYpix(x1pix, y1pix);
		float i1Line = Map.iFloat;
		float j1Line = Map.jFloat;

		float dX = i1Line - i0Line;
		float dY = j1Line - j0Line;

		float i0segment = i0Line;
		float j0segment = j0Line;

		float baseHue = 0.0f;
		float brightMult = 0.0f;
		for (int lineNo = 0; lineNo < 3; lineNo++) {

			switch (lineNo) {

			case 0:
				strokeWeight(10);
				baseHue = 0.65f;
				brightMult = 0.5f;
				break;
			case 1:
				strokeWeight(8);
				baseHue = 0.60f;
				brightMult = 0.9f;
				break;
			case 2:
				strokeWeight(3);
				baseHue = 0.55f;
				brightMult = 1.0f;
				break;
			default:
				/* do nothing */
				break;
			}

			if (Math.abs(dX) > Math.abs(dY)) { // more horizontal; scan i's

				if (Math.abs(dX) > 0.0) { // make sure it is a line, not a point
					// reorder so that X1 > X0
					if (i1Line < i0Line) {
						i0segment = i1Line;
						j0segment = j1Line;
						i1Line = i0Line;
						j1Line = j0Line;
						i0Line = i0segment;
						j0Line = j0segment;
					} else {
						i0segment = i0Line;
						j0segment = j0Line;
					}

					final float alpha = (j1Line - j0Line) / (i1Line - i0Line);

					final int i0 = (int) i0Line + 1;
					final int iN = (int) i1Line;

					for (int i = i0; i <= iN; i++) {

						float i1segment = i;
						float j1segment = j0Line + (i - i0Line) * alpha;

						drawSegment(i0segment, j0segment, i1segment, j1segment, baseHue, brightMult);
						i0segment = i1segment;
						j0segment = j1segment;
					}
					// draw final stub
					drawSegment(i0segment, j0segment, i1Line, j1Line, baseHue, brightMult);
				}

			} else { // more vertical; scan j's

				if (Math.abs(dY) > 0.0) { // make sure it is a line, not a point
					// reorder so that Y1 > Y0
					if (j1Line < j0Line) {
						i0segment = i1Line;
						j0segment = j1Line;
						i1Line = i0Line;
						j1Line = j0Line;
						i0Line = i0segment;
						j0Line = j0segment;
					} else {
						i0segment = i0Line;
						j0segment = j0Line;
					}

					final float alpha = (i1Line - i0Line) / (j1Line - j0Line);

					final int j0 = (int) j0Line + 1;
					final int jN = (int) j1Line;

					for (int j = j0; j <= jN; j++) {

						float i1segment = i0Line + (j - j0Line) * alpha;
						float j1segment = j;

						drawSegment(i0segment, j0segment, i1segment, j1segment, baseHue, brightMult);
						i0segment = i1segment;
						j0segment = j1segment;
					}
					// draw final stub
					drawSegment(i0segment, j0segment, i1Line, j1Line, baseHue, brightMult);
				}
			}
		}
		this.isLineShowing = true;
	}

	void drawSegment(final float i0Float_, final float j0Float_, final float i1Float_, final float j1Float_,
			final float baseHue, final float brightMult) {

		int iAvg = Math.max(0, Math.min(K.gridSize - 1, (int) ((i0Float_ + i1Float_) / 2.0f)));
		int jAvg = Math.max(0, Math.min(K.gridSize - 1, (int) ((j0Float_ + j1Float_) / 2.0f)));

		updateAllColors(iAvg, jAvg, baseHue, brightMult, false);
		drawLine(Map.getXpixFromIJFloatingn(i0Float_, j0Float_), Map.getYpixFromIJFloatingn(i0Float_, j0Float_), Map
				.getXpixFromIJFloatingn(i1Float_, j1Float_), Map.getYpixFromIJFloatingn(i1Float_, j1Float_));
	}

	void updateAllColors(final int i, final int j, final float baseHue, final float brightMult,
			final boolean isSurfaceNoLine) {

		// -----calculate saturation ... defines contrast of text
		float fillSat = 1.0f - 0.8f * States.getContrastForCellIJ(i, j); // minimum sat is 0.2f

		// -----calculate hue
		float diagWidht = Calc.getNodeX(i + 1, j) - Calc.getNodeX(i, j + 1); // grid.loc[K.TR].x - grid.loc[K.BL].x;
		float diagHeight = Calc.getNodeY(i + 1, j) - Calc.getNodeY(i, j + 1); // grid.loc[K.TR].y - grid.loc[K.BL].y;
		float angleHeight2Width;
		if (diagWidht == 0.0) { // unlikely
			angleHeight2Width = 0.5f * HALF_PI;
		} else {
			angleHeight2Width = (float) Math.atan(diagHeight / diagWidht);
		}

		float hue = angleHeight2Width / PI;

		// -----calculate brightness
		float manh2Width = Calc.getManhDist(i + 1, j, i, j) + Calc.getManhDist(i + 1, j + 1, i, j + 1);
		float manh2Height = Calc.getManhDist(i + 1, j, i + 1, j + 1) + Calc.getManhDist(i, j, i, j + 1);
		float manhDiagA = Calc.getManhDist(i + 1, j, i, j + 1);
		float manhDiagB = Calc.getManhDist(i, j, i + 1, j + 1);

		float manhMax = Math.max(Math.max(manh2Width, manh2Height), Math.max(manhDiagA, manhDiagB));
		float manhMin = Math.min(Math.min(manh2Width, manh2Height), Math.min(manhDiagA, manhDiagB));

		float angleMin2Max;
		if (manhMax == 0.0) { // unlikely
			angleMin2Max = 0.5f * HALF_PI;
		} else {
			angleMin2Max = (float) Math.atan(manhMin / manhMax);
		}

		float fillBri = 2.0f * angleMin2Max / HALF_PI; // maximum is one for perfect symmetry
		float fillHue = baseHue - hue + 0.1f * fillBri;
		if (isSurfaceNoLine) {
			// -----calculate fill color
			int rgb = Color.HSBtoRGB(fillHue, fillSat, fillBri);
			fill((rgb >> 16) & 0xFF, (rgb >> 8) & 0xFF, rgb & 0xFF);

			// -----calculate stroke color
			float strokeHue = fillHue;
			float strokeSat = (1.0f - States.getStrokeContrast()) * fillSat;
			float strokeBri = (1.0f - States.getStrokeContrast()) * fillBri;
			rgb = Color.HSBtoRGB(strokeHue, strokeSat, strokeBri);
			stroke((rgb >> 16) & 0xFF, (rgb >> 8) & 0xFF, rgb & 0xFF);

		} else {
			fillHue = baseHue;
			fillBri = brightMult * (0.5f + 0.5f * fillBri);
			// -----calculate fill color
			int rgb = Color.HSBtoRGB(fillHue, fillSat, fillBri);

			stroke((rgb >> 16) & 0xFF, (rgb >> 8) & 0xFF, rgb & 0xFF);
		}
	}
}
