public class PointC {
	float x;
	float y;
	int status; // used for corners 0=not set, 1=guess, 2=exact
	boolean isCut; // used for Cut positions
	float cutFracClock; // 0..1 determines how close from Top or Left corner

	public PointC(final float x_, final float y_, final int s) {
		this.x = x_;
		this.y = y_;
		this.status = s;
	}

	public PointC(final float x_, final float y_, final int s_, final boolean is_, final float cutPos_) {
		this.x = x_;
		this.y = y_;
		this.status = s_;
		this.isCut = is_;
		this.cutFracClock = cutPos_;
	}

	/* Creates a new instance of PointClass. */
	public PointC() {
		this(0.0f, 0.0f, 0, false, 0.0f);
	}

	public final void clear() {
		this.x = 0.0f;
		this.y = 0.0f;
		this.status = 0;
		this.isCut = false;
		this.cutFracClock = 0.0f;
	}

	public final void setPoint(final PointC pc) {
		this.x = pc.x;
		this.y = pc.y;
	}

	public final void setPointAndStatus(final PointC pc, final int s) {
		this.x = pc.x;
		this.y = pc.y;
		this.status = s;
	}

	public final void setAtProportion(final PointC fr, final PointC to, final float p) {
		this.x = ((1.0f - p) * fr.x) + (p * to.x);
		this.y = ((1.0f - p) * fr.y) + (p * to.y);
	}

	public final void setAtIntersection(final PointC fr1, final PointC to1, final PointC fr2, final PointC to2) {
		float a1 = fr1.y - to1.y;
		float b1 = to1.x - fr1.x;
		float c1 = (a1 * fr1.x) + (b1 * fr1.y);

		float a2 = fr2.y - to2.y;
		float b2 = to2.x - fr2.x;
		float c2 = (a2 * fr2.x) + (b2 * fr2.y);

		float det = (a1 * b2) - (a2 * b1);

		if (det == 0) {
			// lines are parallel;
			return;
		}
		this.x = ((b2 * c1) - (b1 * c2)) / det;
		this.y = ((a1 * c2) - (a2 * c1)) / det;
	}

	public final void setGuessFromExtension(final int i, final int j, final int target, final int close) {
		int iTarget = i + K.diLoc(target);
		int jTarget = j + K.djLoc(target);

		int iClose = i + K.diLoc(close);
		int jClose = j + K.djLoc(close);

		int iFar = Math.max(0, (2 * iClose) - iTarget); // TODO added max as shortcut; fix eventually
		int jFar = Math.max(0, (2 * jClose) - jTarget); // TODO added max as shortcut; fix eventually

		float dx = Calc.node[iClose][jClose].x - Calc.node[iFar][jFar].x;
		float dy = Calc.node[iClose][jClose].y - Calc.node[iFar][jFar].y;

		float guessX = Calc.node[iClose][jClose].x + dx;
		float guessY = Calc.node[iClose][jClose].y + dy;

		switch (this.status) {
		case K.NOTSET:
			this.x = guessX;
			this.y = guessY;
			this.status = K.GUESS;

			break;

		case K.GUESS:
			this.x = (this.x + guessX) / 2.0f;
			this.y = (this.y + guessY) / 2.0f;

			// no change in status
			break;

		case K.EXACT:
			// do nothing; do not want to lower precision
			break;

		default:
			/* do nothing */
			break;
		}

	}

	public final void setGuessFromGrid(final int i, final int j, final int baseCorner, final int fromDirection) {
		int di = 0;
		int dj = 0;

		switch (baseCorner) {
		case K.TL:
			di = 0;
			dj = 0;

			break;

		case K.TR:
			di = 1;
			dj = 0;

			break;

		case K.BR:
			di = 1;
			dj = 1;

			break;

		case K.BL:
			di = 0;
			dj = 1;

			break;
		default:
			/* do nothing */
			break;
		}

		int baseCornerI = i + di;
		int baseCornerJ = j + dj;

		switch (fromDirection) {
		case K._FromLft:
			di = -1;
			dj = 0;

			break;

		case K._FromTop:
			di = 0;
			dj = -1;

			break;

		case K._FromRgt:
			di = 1;
			dj = 0;

			break;

		case K._FromBot:
			di = 0;
			dj = 1;

			break;
		default:
			/* do nothing */
			break;
		}

		int referenceI = baseCornerI + di;
		int referenceJ = baseCornerJ + dj;

		float dx = Calc.node[baseCornerI][baseCornerJ].x - Calc.node[referenceI][referenceJ].x;
		float dy = Calc.node[baseCornerI][baseCornerJ].y - Calc.node[referenceI][referenceJ].y;

		float guessX = Calc.node[baseCornerI][baseCornerJ].x + dx;
		float guessY = Calc.node[baseCornerI][baseCornerJ].y + dy;

		switch (this.status) {
		case K.NOTSET:
			this.x = guessX;
			this.y = guessY;
			this.status = K.GUESS;

			break;

		case K.GUESS:
			this.x = (this.x + guessX) / 2.0f;
			this.y = (this.y + guessY) / 2.0f;

			// no change in status
			break;

		case K.EXACT:

			// do nothing; do not want to lower precision
			break;
		default:
			/* do nothing */
			break;
		}
	}
}
