/* this class maps between the grid representation of the surface and the screen */

final class Map {

	// -----used to access mapped values [bad java prgramming style!]
	static float iFloat;
	static float jFloat;

	// ---------------------------------------------------
	private static float i0rip;
	private static float i1rip;
	private static float j0rip;
	private static float j1rip;

	//----------------------------------------------------
	private static final int windowWidth = 860; // could use 1216; // 1280 ..or 1024 - 64 = 960 for firefox pad
	private static final int windowHeight = 860; // 1024 ..or 768 - 184 = 584 for firefox pad
	private static final int appletPadYpix = 160;
	private static int canvasSizePix;

	// ----------------------------------------------------
	private static float gridTopLeftXpix;
	private static float gridTopLeftYpix;
	private static float gridSizePix;
	private static float pixPerCell;
	// ----------------------------------------------------
	private static final float border0to1 = 0.05f;
	private static final float oneLess2xBorder0to1 = 1.0f - border0to1 * 2.0f;
	private static final float panAndZoomAlpha = 0.1f;

	private static float centerPosX0to1; // Varies from 0 to 1
	private static float centerVelX0to1;
	private static float centerPosY0to1;
	private static float centerVelY0to1;

	private static float gridSize0to1;
	private static float gridVelo0to1;


	private Map() {
		/* empty */
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	static void setCanvasSizePix(final boolean isBrowser, final int scrWidth, final int scrHeight) {
		// -----sets largest window size that maintains desired square canvas
		if (isBrowser) {
			canvasSizePix = Math.min(windowWidth, windowHeight);
		} else {
			canvasSizePix = Math.min(scrWidth, scrHeight - appletPadYpix);
		}
	}

	static int getCanvasSizePix() {
		return canvasSizePix;
	}

	static float getGridSize0to1() {
		return gridSize0to1;
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	static void resetPandAndZoom() {

		K.xMinCells = 0.0f;
		K.xMaxCells = K.gridSize;
		K.yMinCells = 0.0f;
		K.yMaxCells = K.gridSize;

		centerPosX0to1 = 0.5f; // Varies from 0 to 1
		centerVelX0to1 = 0.0f;

		centerPosY0to1 = 0.5f;
		centerVelY0to1 = 0.0f;

		gridSize0to1 = oneLess2xBorder0to1;
		gridVelo0to1 = 0.0f;
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	static void autoPanAndZoom() {

		float centerPosX0to1exact;
		float centerPosY0to1exact;
		float gridSize0to1exact;
		float cellSize0to1exact;

		float gridSizeHalf = K.gridSize / 2.0f;

		float blobSizeXcells = K.xMaxCells - K.xMinCells; // expressed in cell units
		float blobSizeYcells = K.yMaxCells - K.yMinCells;

		if (blobSizeXcells > blobSizeYcells) { // longer width

			// calc exact center of grid (0 to 1) and exact size of grid (0 to 1) so that tentacles just touch border
			cellSize0to1exact = oneLess2xBorder0to1 / blobSizeXcells;
			centerPosX0to1exact = border0to1 + cellSize0to1exact * (gridSizeHalf - K.xMinCells);
			gridSize0to1exact = cellSize0to1exact * K.gridSize;

			// then place center in other axis closest to middle of canvas
			if ((K.gridSize - K.yMaxCells) < K.yMinCells) { // compare negatives; here top tentacle longer than bottom
				// one

				float distOfTentacleToGridCenter0to1 = (K.yMaxCells - gridSizeHalf) * cellSize0to1exact;
				if (distOfTentacleToGridCenter0to1 > (0.5 - border0to1)) {
					centerPosY0to1exact = 1.0f - border0to1 - distOfTentacleToGridCenter0to1;
				} else {
					centerPosY0to1exact = 0.5f;
				}

			} else { // bottom tentacle longer than top one

				float distOfTentacleToGridCenter0to1 = (gridSizeHalf - K.yMinCells) * cellSize0to1exact;
				if (distOfTentacleToGridCenter0to1 > (0.5 - border0to1)) {
					centerPosY0to1exact = border0to1 + distOfTentacleToGridCenter0to1;
				} else {
					centerPosY0to1exact = 0.5f;
				}
			}

		} else { // longer height

			// calc exact center of grid (0 to 1) and exact size of grid (0 to 1) so that tentacles just touch border
			cellSize0to1exact = oneLess2xBorder0to1 / blobSizeYcells;
			centerPosY0to1exact = border0to1 + cellSize0to1exact * (gridSizeHalf - K.yMinCells);
			gridSize0to1exact = cellSize0to1exact * K.gridSize;

			// then place center in other axis closest to middle of canvas
			if ((K.gridSize - K.xMaxCells) < K.xMinCells) { // compare negatives; here top tentacle longer than bottom
				// one

				float distOfTentacleToGridCenter = (K.xMaxCells - gridSizeHalf) * cellSize0to1exact;
				if (distOfTentacleToGridCenter > (0.5 - border0to1)) {
					centerPosX0to1exact = 1.0f - border0to1 - distOfTentacleToGridCenter;
				} else {
					centerPosX0to1exact = 0.5f;
				}

			} else { // bottom tentacle longer than top one

				float distOfTentacleToGridCenter = (gridSizeHalf - K.xMinCells) * cellSize0to1exact;
				if (distOfTentacleToGridCenter > (0.5 - border0to1)) {
					centerPosX0to1exact = border0to1 + distOfTentacleToGridCenter;
				} else {
					centerPosX0to1exact = 0.5f;
				}
			}
		}

		// ====================================================================
		// Smoothing pan and zoom
		float centerVelX0to1exact = centerPosX0to1exact - centerPosX0to1;
		centerVelX0to1 = panAndZoomAlpha * centerVelX0to1exact + (1.0f - panAndZoomAlpha) * centerVelX0to1;
		centerPosX0to1 += centerVelX0to1;

		float centerVelY0to1exact = centerPosY0to1exact - centerPosY0to1;
		centerVelY0to1 = panAndZoomAlpha * centerVelY0to1exact + (1.0f - panAndZoomAlpha) * centerVelY0to1;
		centerPosY0to1 += centerVelY0to1;

		float gridVelo0to1exact = gridSize0to1exact - gridSize0to1;
		gridVelo0to1 = panAndZoomAlpha * gridVelo0to1exact + (1.0f - panAndZoomAlpha) * gridVelo0to1;
		gridSize0to1 += gridVelo0to1;

		// finally update parameters used to convert cell coordinates to pixels
		gridSizePix = gridSize0to1 * canvasSizePix;
		gridTopLeftXpix = canvasSizePix * (centerPosX0to1 - gridSize0to1 / 2.0f);
		gridTopLeftYpix = canvasSizePix * (centerPosY0to1 - gridSize0to1 / 2.0f);
		pixPerCell = gridSizePix / K.gridSize;
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	// always use i, j as the grid coordinates and x, y as the node positions
	static float nodeFlX(final float iFl, final float jFl) {

		int i = (int) iFl;
		int j = (int) jFl;

		float iFrac = iFl - i;
		float jFrac = jFl - j;

		float _TLx = Calc.getNodeX(i, j);
		float _TRx = Calc.getNodeX(i + 1, j);
		float _BLx = Calc.getNodeX(i, j + 1);
		float _BRx = Calc.getNodeX(i + 1, j + 1);

		float _Lx = jFrac * _BLx + (1.0f - jFrac) * _TLx;
		float _Rx = jFrac * _BRx + (1.0f - jFrac) * _TRx;

		return (iFrac * _Rx + (1.0f - iFrac) * _Lx);
	}

	static float nodeFlY(final float iFl, final float jFl) {

		int i = (int) iFl;
		int j = (int) jFl;

		float iFrac = iFl - i;
		float jFrac = jFl - j;

		float _TLy = Calc.getNodeY(i, j);
		float _TRy = Calc.getNodeY(i + 1, j);
		float _BLy = Calc.getNodeY(i, j + 1);
		float _BRy = Calc.getNodeY(i + 1, j + 1);

		float _Ly = jFrac * _BLy + (1.0f - jFrac) * _TLy;
		float _Ry = jFrac * _BRy + (1.0f - jFrac) * _TRy;

		return (iFrac * _Ry + (1.0f - iFrac) * _Ly);
	}

	static void updateIFloatAndJFloatFromXYpix(final int xPix, final int yPix) {

		final float tgtX = getCellXFromScreen(xPix);
		final float tgtY = getCellYFromScreen(yPix);

		final float tolerance = 0.5f / pixPerCell; // tolerance of 1/2 a pixel

		iFloat = tgtX;
		jFloat = tgtY;

		float errorManh;
		int iters = 0;
		// assumes relatively "undistorted" grid, where di mosty impacts dX and dj impacts dY
		// try to do one at a time; first i then j
		do {
			float xGuess = nodeFlX(iFloat, jFloat);
			float xError = tgtX - xGuess;
			iFloat += xError * 0.8; // slight damping

			float yGuess = nodeFlY(iFloat, jFloat);
			float yError = tgtY - yGuess;
			jFloat += yError * 0.8; // slight damping

			errorManh = Math.abs(xError) + Math.abs(yError);
			iters++;
		} while ((errorManh > tolerance) && (iters <= 100));
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	static void disturbGridIfNeeded() {

		updateIFloatAndJFloatFromXYpix(RIP.ripX1, RIP.ripY1);

		int iTickled = Math.max(1, Math.min(K.gridSize - 1, (int) (0.5f + iFloat)));
		int jTickled = Math.max(1, Math.min(K.gridSize - 1, (int) (0.5f + jFloat)));

		float manhDist = Math.abs(Calc.node[iTickled][jTickled].x - iTickled) + Math.abs(Calc.node[iTickled][jTickled].y - jTickled);
		if (manhDist < 0.1f) {
			Calc.node[iTickled][ jTickled].x += 0.2f * ((float) Math.random() - 0.5f);
			Calc.node[iTickled][ jTickled].y += 0.2f * ((float) Math.random() - 0.5f);
		}
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////


	static void interpretLineGesturesAndStoreRipCoords() {

		updateIFloatAndJFloatFromXYpix(RIP.ripX0, RIP.ripY0);
		i0rip = iFloat;
		j0rip = jFloat;

		updateIFloatAndJFloatFromXYpix(RIP.ripX1, RIP.ripY1);
		i1rip = iFloat;
		j1rip = jFloat;

		// calculate rip ... first put within boundaries
		boolean isRipOnCanvas = true;
		// -----clip at 0.001..0.999 ... allows for gridsize 1000
		float clipLow = 0.001f * K.gridSize + 1.0f; // one cell and a bit to the right
		float clipHigh = 1.0f * K.gridSize - clipLow; // one cell and a bit to the left

		if (i0rip < clipLow) {

			if (i1rip > clipLow) {
				j0rip += (clipLow - i0rip) * (j1rip - j0rip) / (i1rip - i0rip);
				i0rip = clipLow;

			} else {
				isRipOnCanvas = false;
			}
		} else if (i0rip > clipHigh) {

			if (i1rip < clipHigh) {
				j0rip += (clipHigh - i0rip) * (j1rip - j0rip) / (i1rip - i0rip);
				i0rip = clipHigh;

			} else {
				isRipOnCanvas = false;
			}
		}

		if (j0rip < clipLow) {

			if (j1rip > clipLow) {
				i0rip += (clipLow - j0rip) * (i1rip - i0rip) / (j1rip - j0rip);
				j0rip = clipLow;

			} else {
				isRipOnCanvas = false;
			}
		} else if (j0rip > clipHigh) {

			if (j1rip < clipHigh) {
				i0rip += (clipHigh - j0rip) * (i1rip - i0rip) / (j1rip - j0rip);
				j0rip = clipHigh;

			} else {
				isRipOnCanvas = false;
			}
		}

		if (i1rip < clipLow) {

			if (i0rip > clipLow) {
				j1rip += (clipLow - i1rip) * (j1rip - j0rip) / (i1rip - i0rip);
				i1rip = clipLow;

			} else {
				isRipOnCanvas = false;
			}
		} else if (i1rip > clipHigh) {

			if (i0rip < clipHigh) {
				j1rip += (clipHigh - i1rip) * (j1rip - j0rip) / (i1rip - i0rip);
				i1rip = clipHigh;

			} else {
				isRipOnCanvas = false;
			}
		}

		if (j1rip < clipLow) {

			if (j0rip > clipLow) {
				i1rip += (clipLow - j1rip) * (i1rip - i0rip) / (j1rip - j0rip);
				j1rip = clipLow;

			} else {
				isRipOnCanvas = false;
			}
		} else if (j1rip > clipHigh) {

			if (j0rip < clipHigh) {
				i1rip += (clipHigh - j1rip) * (i1rip - i0rip) / (j1rip - j0rip);
				j1rip = clipHigh;

			} else {
				isRipOnCanvas = false;
			}
		}

		float manhDist = Math.abs(i1rip - i0rip) + Math.abs(j1rip - j0rip);
		States.interpretLineGesturesIntoActions(isRipOnCanvas, manhDist);
	}


	static void implementRip() {
		Calc.createDiagonalRip(i0rip, j0rip, i1rip, j1rip);
	}


	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	static boolean isCenterGridCloseToCenterWindow() {
		return ((Math.abs(centerPosX0to1 - 0.5) < 0.02) && (Math.abs(centerPosY0to1 - 0.5) < 0.02));
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	static int getXpix(final float x0to1) {
		return (int) (0.5 + gridTopLeftXpix + x0to1 * pixPerCell);
	}

	static int getYpix(final float y0to1) {
		return (int) (0.5 + gridTopLeftYpix + y0to1 * pixPerCell);
	}

	static int getXpixFromIJFloatingn(final float iFl, final float jFl) {
		return (int) (0.5 + gridTopLeftXpix + nodeFlX(iFl, jFl) * pixPerCell);
	}

	static int getYpixFromIJFloatingn(final float iFl, final float jFl) {
		return (int) (0.5 + gridTopLeftYpix + nodeFlY(iFl, jFl) * pixPerCell);
	}

	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////
	// ////////////////////////////////////////////////////////////////////////

	private static float getCellXFromScreen(final int xPix) {
		return ((xPix - gridTopLeftXpix) / pixPerCell);
	}

	private static float getCellYFromScreen(final int yPix) {
		return ((yPix - gridTopLeftYpix) / pixPerCell);
	}

}
