/* this class holds the shared static variables and some utility methods */

import java.text.DecimalFormat;

final class K { // USED FOR CONSTANTS AND SHARED VARS

	static float springSizAtRest = 0.0f; // 0.0; // 0.7;
	static float bending2Elastic = 1.0f; // 1.0; // 0.4 like flower; // 0.5;
	static float elasticConstant = 0.1f; // good compromise speed vs smoothness
	public static float cell_HalfBorder;

	// Observation: instability when crosses over (e.g. folds)
	// =====================================================
	public static final int gridSizeMAX = 40; // should increase if gridSize set to vary
	public static final int gridSize = 40; // 20 and 30 give nice results // default feasible up to 320

	// ----- these are updated by calc and used in draw.autoPanAndZoom
	static float xMinCells;
	static float xMaxCells;
	static float yMinCells;
	static float yMaxCells;

	// LOCATIONS ON TETRA
	static final int nLOC = 8; // do not change. Impacts many methods.

	// -----------------------------------------
	static final int TL = 0; // corner
	static final int TC = 1; // cut location
	static final int TR = 2;
	static final int RC = 3;
	static final int BR = 4;
	static final int BC = 5;
	static final int BL = 6;
	static final int LC = 7; // do not change order!

	// STATUS OF COORDINATES x AND y
	static final int NOTSET = 0;
	static final int EXACT = 1; // copied from Grid ... used in Ou
	static final int GUESS = 2; // projected from _Exact and extension Far-Close-Guess
	static final int VISIBLE = 3; // only used in In
	static final int INVISIBLE = 4; // used only for In
	// "Guess" is always invisible

	// DIRECTIONS
	static final int _FromLft = 0;
	static final int _FromTop = 1;
	static final int _FromRgt = 2;
	static final int _FromBot = 3;

	// SHAPECODE
	static final int _shapeCodeTop = 1;
	static final int _shapeCodeRgt = 2;
	static final int _shapeCodeBot = 4;
	static final int _shapeCodeLft = 8;

    static DecimalFormat myDouble3 = new DecimalFormat("###,###,##0.000");

	// ==========================================================================
	// DISABLE CONTRUCTION OUTSIDE OF THIS CLASS
	private K() {
		/* empty */
	}

	// ==========================================================================
	public static int diLoc(final int n) {

		if ((n > TC) && (n < BL)) {
			return (1);
		}
		return (0);
	}

	public static int djLoc(final int n) {

		if (n > RC) {
			return (1);
		}
		return (0);
	}

	public static boolean isCorner(final int n) {
		return ((n % 2) == 0);
	}

	public static int nextLoc(final int n) {
		if (n >= (nLOC - 1)) { // if n == 7

			return (0);
		}
		return (n + 1);
	}

	public static int prevLoc(final int n) {
		if (n <= 0) {
			return (nLOC - 1); // 7
		}
		return (n - 1);
	}

	public static int oppositeLoc(final int n) { // assumes even number of locations
		return ((n + nLOC / 2) % nLOC);
	}

	public static int nextCorner(final int n) {
		if (isCorner(n)) {
			return ((n + 2) % nLOC);
		}
		return ((n + 1) % nLOC);
	}

	public static int prevCorner(final int n) {
		if (isCorner(n)) {
			return (((n + nLOC) - 2) % nLOC);
		}
		return (((n + nLOC) - 1) % nLOC);
	}

	public static int nextCutLoc(final int n) {
		if (isCorner(n)) {
			return ((n + 1) % nLOC);
		}
		return ((n + 2) % nLOC);
	}

	public static int prevCutLoc(final int n) {
		if (isCorner(n)) {
			return (((n + nLOC) - 1) % nLOC);
		}
		return (((n + nLOC) - 2) % nLOC);
	}

	// ========================================================================

    static String rightText(final String inText, final int desiredLength) {
        StringBuffer result = new StringBuffer("");
        int pad = 2 * Math.max(0, desiredLength - inText.length());
        if (pad > 0) {
            for (int i = 1; i <= pad; i++) {
                result.append(" "); // should be extra / 2 but spaces are narrower than other chars
            }
        }
        return result.append(inText).toString();
    }

    static String doubleToDouble3(final double d) {
        return (rightText(myDouble3.format(d), 4));
    }
}
